/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.trace;

import java.util.Optional;
import java.util.UUID;

public final class HttpRequestTraceRecord {
    private final UUID uniqueId;
    private final Long sessionId;
    private final Long loggingTimeEpochMilliseconds;
    private final String requestUri;
    private final int remotePort;
    private final String requestBody;

    private HttpRequestTraceRecord(Builder builder) {
        this.uniqueId = builder.uniqueId;
        this.sessionId = builder.sessionId;
        this.loggingTimeEpochMilliseconds = builder.loggingTimeEpochMilliseconds;
        this.requestUri = builder.requestUri;
        this.remotePort = builder.remotePort;
        this.requestBody = builder.requestBody;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public Optional<Long> getSessionId() {
        return Optional.ofNullable(this.sessionId);
    }

    public Optional<Long> getLoggingTimeEpochMilliseconds() {
        return Optional.ofNullable(this.loggingTimeEpochMilliseconds);
    }

    public Optional<String> getRequestUri() {
        return Optional.ofNullable(this.requestUri);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public Optional<String> getRequestBody() {
        return Optional.ofNullable(this.requestBody);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID uniqueId;
        private Long sessionId;
        private Long loggingTimeEpochMilliseconds;
        private String requestUri;
        private int remotePort;
        private String requestBody;

        Builder() {
        }

        public Builder uniqueId(UUID val) {
            this.uniqueId = val;
            return this;
        }

        public Builder sessionId(Long val) {
            this.sessionId = val;
            return this;
        }

        public Builder loggingTimeEpochMilliseconds(Long val) {
            this.loggingTimeEpochMilliseconds = val;
            return this;
        }

        public Builder requestUri(String val) {
            this.requestUri = val;
            return this;
        }

        public Builder remotePort(int val) {
            this.remotePort = val;
            return this;
        }

        public Builder requestBody(String val) {
            this.requestBody = val;
            return this;
        }

        public HttpRequestTraceRecord build() {
            return new HttpRequestTraceRecord(this);
        }
    }
}

