/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.http.core;

import com.ericsson.lwac.net.http.core.HttpQueryParameter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HttpQueryParameters
implements Iterable<HttpQueryParameter> {
    public static final HttpQueryParameters EMPTY = new HttpQueryParameters(ImmutableList.of());
    @Valid
    private final List<HttpQueryParameter> parameters;

    private HttpQueryParameters(List<HttpQueryParameter> parameters) {
        this.parameters = parameters;
    }

    public Collection<HttpQueryParameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    @Override
    public Iterator<HttpQueryParameter> iterator() {
        return this.getParameters().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpQueryParameters that = (HttpQueryParameters)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hashCode(this.parameters);
    }

    public static HttpQueryParameters fromNameAndValues(String name, Iterable<String> values) {
        Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
        Preconditions.checkNotNull(values, "'values' is invalid, values not be null");
        return StreamSupport.stream(values.spliterator(), false).map(value -> HttpQueryParameter.fromNameAndValue(name, value)).filter(Objects::nonNull).collect(HttpQueryParameters.collector());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static HttpQueryParameterCollector collector() {
        return new HttpQueryParameterCollector();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public int size() {
        return this.parameters.size();
    }

    public HttpQueryParameters plus(HttpQueryParameters that) {
        if (that == null || that.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return that;
        }
        return new HttpQueryParameters((List<HttpQueryParameter>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.parameters)).addAll(that.parameters)).build()));
    }

    public HttpQueryParameters plus(HttpQueryParameter that) {
        if (that == null) {
            return this;
        }
        return new HttpQueryParameters((List<HttpQueryParameter>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.parameters)).add(that)).build()));
    }

    public Optional<HttpQueryParameter> findByName(String name) {
        return HttpQueryParameter.findByName(this, name);
    }

    public Optional<String> findValueByName(String name) {
        return HttpQueryParameter.findValueByName(this, name);
    }

    public List<HttpQueryParameter> findAllByName(String name) {
        return HttpQueryParameter.findAllByName(this, name);
    }

    public List<String> findAllValuesByName(String name) {
        return HttpQueryParameter.findAllValuesByName(this, name);
    }

    public static HttpQueryParameters one(String name, String value) {
        return HttpQueryParameters.newBuilder().parameter(name, value).build();
    }

    public static HttpQueryParameters one(HttpQueryParameter parameter) {
        return HttpQueryParameters.newBuilder().parameter(parameter).build();
    }

    public static HttpQueryParameters of(Iterable<HttpQueryParameter> parameters) {
        return HttpQueryParameters.newBuilder().parameters(parameters).build();
    }

    public static final class HttpQueryParameterCollector
    implements Collector<Iterable<HttpQueryParameter>, Builder, HttpQueryParameters> {
        private HttpQueryParameterCollector() {
        }

        @Override
        public Supplier<Builder> supplier() {
            return Builder::new;
        }

        @Override
        public BiConsumer<Builder, Iterable<HttpQueryParameter>> accumulator() {
            return Builder::parameters;
        }

        @Override
        public BinaryOperator<Builder> combiner() {
            return (right, left) -> right.parameters(left.parameters.build());
        }

        @Override
        public Function<Builder, HttpQueryParameters> finisher() {
            return Builder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of();
        }
    }

    public static final class Builder {
        private ImmutableList.Builder<HttpQueryParameter> parameters;

        public Builder parameters(Iterable<HttpQueryParameter> parameters) {
            Preconditions.checkNotNull(parameters, "'parameters' is invalid, can not be null");
            for (HttpQueryParameter parameter : parameters) {
                this.parameter(parameter);
            }
            return this;
        }

        public Builder parameter(HttpQueryParameter parameter) {
            if (parameter != null) {
                if (this.parameters == null) {
                    this.parameters = ImmutableList.builder();
                }
                this.parameters.add((Object)parameter);
            }
            return this;
        }

        public Builder parameter(String name, String value) {
            Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
            if (value != null) {
                return this.parameter(HttpQueryParameter.newBuilder().name(name).value(value).build());
            }
            return this;
        }

        public Builder parameter(String name, BigDecimal value) {
            Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
            if (value != null) {
                return this.parameter(HttpQueryParameter.newBuilder().name(name).value(value.toPlainString()).build());
            }
            return this;
        }

        public Builder parameter(String name, Boolean value) {
            Preconditions.checkNotNull(name, "'name' is invalid, can not be null");
            if (value != null) {
                return this.parameter(HttpQueryParameter.newBuilder().name(name).value(String.valueOf(value)).build());
            }
            return this;
        }

        public HttpQueryParameters build() {
            if (this.parameters == null) {
                return EMPTY;
            }
            return new HttpQueryParameters((List<HttpQueryParameter>)((Object)this.parameters.build()));
        }
    }
}

