/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.messagebus;

import java.util.HashMap;
import java.util.Map;

public class ProducerProperties {
    private final AckPolicy acks;

    private ProducerProperties(Builder builder) {
        this.acks = builder.acks;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAcks() {
        return this.acks.value();
    }

    public static final class Builder {
        private AckPolicy acks = AckPolicy.PERSISTED;

        private Builder() {
        }

        public Builder acks(AckPolicy val) {
            this.acks = val;
            return this;
        }

        public ProducerProperties build() {
            return new ProducerProperties(this);
        }
    }

    public static enum AckPolicy {
        RECEIVED("0"),
        PERSISTED("1"),
        PERSISTED_AND_REPLICATED("-1");

        private String ackLevel;
        private static final Map<String, AckPolicy> lookup;

        private AckPolicy(String ackLevel) {
            this.ackLevel = ackLevel;
        }

        String value() {
            return this.ackLevel;
        }

        public static AckPolicy getFromValue(String value) {
            if ("all".equals(value)) {
                return lookup.get("-1");
            }
            return lookup.get(value);
        }

        static {
            lookup = new HashMap<String, AckPolicy>();
            for (AckPolicy ap : AckPolicy.values()) {
                lookup.put(ap.value(), ap);
            }
        }
    }
}

