/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.kubernetes;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SecretPath {
    private static final Pattern secretPathPattern = Pattern.compile("secret/([\\w-._]+)/([\\w-._]+)");
    private final SecretType secretType;
    private final String secretName;
    private final String secretFieldName;

    private SecretPath(SecretType secretType, String secretName, String secretFieldName) {
        this.secretType = secretType;
        this.secretName = secretName;
        this.secretFieldName = secretFieldName;
    }

    public static SecretPath create(String path) {
        Matcher matcher = secretPathPattern.matcher(path);
        if (matcher.matches()) {
            String secretName = matcher.group(1);
            String secretField = matcher.group(2);
            return new SecretPath(SecretType.SECRET, secretName, secretField);
        }
        throw new IllegalArgumentException("Could not match secret path " + path);
    }

    public SecretType getSecretType() {
        return this.secretType;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public String getSecretFieldName() {
        return this.secretFieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretPath that = (SecretPath)o;
        return Objects.equals(this.secretName, that.secretName) && Objects.equals(this.secretFieldName, that.secretFieldName);
    }

    public int hashCode() {
        return Objects.hash(this.secretName, this.secretFieldName);
    }

    public String toString() {
        return this.secretType.toString().toLowerCase() + "/" + this.secretName + "/" + this.secretFieldName;
    }

    public static enum SecretType {
        SECRET;

    }
}

