/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.kubernetes;

import com.ericsson.lwac.kubernetes.KubernetesObject;
import com.ericsson.lwac.kubernetes.MetaData;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Secret
implements KubernetesObject {
    private final MetaData metadata;
    private final String apiVersion = "v1";
    private final String kind = "Secret";
    private final Map<String, String> data;

    private Secret(Builder builder) {
        this.metadata = builder.metadata;
        this.data = builder.data;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Secret copy) {
        Builder builder = new Builder();
        builder.metadata = copy.getMetadata();
        builder.data = copy.data == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(copy.data);
        return builder;
    }

    @Override
    public MetaData getMetadata() {
        return this.metadata;
    }

    public String getApiVersion() {
        return "v1";
    }

    @Override
    public String getKind() {
        return "Secret";
    }

    public Map<String, String> getData() {
        if (this.data != null) {
            return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new String(Base64.getDecoder().decode((String)entry.getValue()))));
        }
        return Collections.emptyMap();
    }

    public Map<String, byte[]> getRawData() {
        if (this.data != null) {
            return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Base64.getDecoder().decode((String)entry.getValue())));
        }
        return Collections.emptyMap();
    }

    public static final class Builder {
        private Map<String, String> data = new LinkedHashMap<String, String>();
        private MetaData metadata;

        private Builder() {
        }

        public Builder metadata(MetaData val) {
            this.metadata = val;
            return this;
        }

        public Builder data(String key, String value) {
            this.data.put(key, Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8)));
            return this;
        }

        public Builder data(String key, byte[] val) {
            this.data.put(key, Base64.getEncoder().encodeToString(val));
            return this;
        }

        public Secret build() {
            return new Secret(this);
        }
    }
}

