/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.kubernetes;

import com.ericsson.lwac.kubernetes.KubernetesObject;
import com.ericsson.lwac.kubernetes.MetaData;
import java.time.ZonedDateTime;

public final class Pod
implements KubernetesObject {
    private final MetaData metadata;
    private final String apiVersion = "v1";
    private final String kind = "Pod";
    private final ZonedDateTime startTime;

    private Pod(Builder builder) {
        this.metadata = builder.metadata;
        this.startTime = builder.startTime;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public MetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public String getKind() {
        return "Pod";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MetaData metadata;
        private ZonedDateTime startTime;

        private Builder() {
        }

        public Builder metadata(MetaData metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder startTime(ZonedDateTime value) {
            this.startTime = value;
            return this;
        }

        public Pod build() {
            return new Pod(this);
        }
    }
}

