/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.kubernetes;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class MetaData {
    @Nullable
    private final String name;
    @Nullable
    private final String resourceVersion;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final Map<String, String> annotations;

    private MetaData(Builder builder) {
        this.name = builder.name;
        this.resourceVersion = builder.resourceVersion;
        this.labels = builder.labels == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.labels);
        this.annotations = builder.annotations == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.annotations);
    }

    private MetaData(String name) {
        this.name = name;
        this.resourceVersion = null;
        this.labels = Collections.emptyMap();
        this.annotations = Collections.emptyMap();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getResourceVersion() {
        return Optional.ofNullable(this.resourceVersion);
    }

    public Optional<String> getLabel(LabelKey key) {
        return Optional.ofNullable(this.labels == null ? null : this.labels.get(key.key()));
    }

    public Stream<Map.Entry<LabelKey, String>> getLabels() {
        return this.labels == null ? Stream.empty() : this.labels.entrySet().stream().map(e -> Map.entry(StringLabelKey.of((String)e.getKey()), (String)e.getValue()));
    }

    public Optional<String> getAnnotation(String key) {
        return Optional.ofNullable(this.annotations == null ? null : this.annotations.get(key));
    }

    public Stream<Map.Entry<String, String>> getAnnotations() {
        return this.annotations == null ? Stream.empty() : this.annotations.entrySet().stream().map(e -> Map.entry((String)e.getKey(), (String)e.getValue()));
    }

    public static MetaData valueOf(String val) {
        return new MetaData(val);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String resourceVersion;
        private Map<String, String> labels;
        private Map<String, String> annotations;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public Builder withLabel(LabelKey key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(key.key(), value);
            return this;
        }

        public Builder withAnnotation(String key, String value) {
            if (this.annotations == null) {
                this.annotations = new LinkedHashMap<String, String>();
            }
            this.annotations.put(key, value);
            return this;
        }

        public MetaData build() {
            return new MetaData(this);
        }
    }

    public static interface LabelKey {
        public String key();
    }

    public static class StringLabelKey
    implements LabelKey,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String key;

        private StringLabelKey(String key) {
            this.key = key;
        }

        public static StringLabelKey of(String k) {
            Objects.requireNonNull(k);
            return new StringLabelKey(k);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringLabelKey that = (StringLabelKey)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        @Override
        public String key() {
            return this.key;
        }

        public String toString() {
            return "StringLabelKey{key='" + this.key + "'}";
        }
    }
}

