/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.kubernetes;

import com.ericsson.lwac.kubernetes.KubernetesObject;
import com.ericsson.lwac.kubernetes.MetaData;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ConfigMap
implements KubernetesObject {
    private final MetaData metadata;
    private final String apiVersion = "v1";
    private final String kind = "ConfigMap";
    private final Map<String, String> data;

    private ConfigMap(Builder builder) {
        this.metadata = builder.metadata;
        this.data = builder.data;
    }

    public static Builder newBuilder(ConfigMap copy) {
        Builder builder = new Builder();
        builder.metadata = copy.getMetadata();
        builder.data = copy.data == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(copy.data);
        return builder;
    }

    public Map<String, String> getData() {
        return this.data == null ? new LinkedHashMap() : this.data;
    }

    @Override
    public MetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public String getKind() {
        return "ConfigMap";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> data = new LinkedHashMap<String, String>();
        private MetaData metadata;

        private Builder() {
        }

        public Builder data(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder data(Map<String, String> value) {
            this.data.putAll(value);
            return this;
        }

        public ConfigMap build() {
            return new ConfigMap(this);
        }

        public Builder metadata(MetaData val) {
            this.metadata = val;
            return this;
        }
    }
}

