/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.jobs;

import com.ericsson.lwac.deployer.BeanId;
import com.ericsson.lwac.jobs.Job;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class JobInitiator
implements Serializable,
Comparable<JobInitiator> {
    private static final long serialVersionUID = 1L;
    private final BeanId beanId;
    private final List<Job> currentJobs;

    private JobInitiator(Builder builder) {
        this.beanId = builder.beanId;
        this.currentJobs = builder.currentJobs;
    }

    public BeanId getBeanId() {
        return this.beanId;
    }

    public List<Job> getCurrentJobs() {
        return this.currentJobs;
    }

    @Override
    public int compareTo(JobInitiator o) {
        return this.getBeanId().getId().compareTo(o.getBeanId().getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanId == null ? 0 : this.beanId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobInitiator other = (JobInitiator)obj;
        return !(this.beanId == null ? other.beanId != null : !this.beanId.equals(other.beanId));
    }

    public static Builder newBuilder(BeanId beanId) {
        return new Builder(beanId);
    }

    public static final class Builder {
        private final BeanId beanId;
        private final List<Job> currentJobs = new LinkedList<Job>();

        private Builder(BeanId beanId) {
            this.beanId = beanId;
        }

        public Builder addJob(Job job) {
            this.currentJobs.add(job);
            return this;
        }

        public JobInitiator build() {
            return new JobInitiator(this);
        }
    }
}

