/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.jobs;

import com.ericsson.lwac.jobs.JobId;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class Job
implements Serializable,
Comparable<Job> {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final JobState jobState;
    private final String comment;
    private final LocalDateTime startTime;
    private final LocalDateTime endTime;

    Job(JobId jobId, String comment, LocalDateTime startTime, LocalDateTime endTime) {
        this.jobId = jobId;
        this.comment = comment;
        this.startTime = startTime;
        this.endTime = endTime;
        this.jobState = endTime == null ? JobState.RUNNING : JobState.FINISHED;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public String getComment() {
        return this.comment;
    }

    public Duration getRunTime() {
        return this.endTime == null ? Duration.between(this.startTime, LocalDateTime.now()) : Duration.between(this.startTime, this.endTime);
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public int compareTo(Job o) {
        if (this == o) {
            return 0;
        }
        int result = 0;
        if (this.jobState == o.jobState) {
            if (this.jobState == JobState.RUNNING) {
                result = (int)((o.getStartTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - this.getStartTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()) / 1000L);
            } else if (this.jobState == JobState.FINISHED) {
                result = (int)((o.getEndTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - this.getEndTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()) / 1000L);
            }
            if (result == 0) {
                result = this.jobId.getId().compareTo(o.getJobId().getId());
            }
        } else {
            result = this.jobState == JobState.RUNNING ? 1 : -1;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Job other = (Job)obj;
        if (this.jobId == null) {
            return other.jobId == null;
        }
        return this.jobId.equals(other.jobId);
    }

    public static enum JobState {
        RUNNING,
        FINISHED;

    }
}

