/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml.async;

import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.RequestCorrelationId;
import com.ericsson.lwac.http.core.CustomHttpResponse;
import com.ericsson.lwac.http.core.HttpBadRequestException;
import com.ericsson.lwac.http.core.HttpHeader;
import com.ericsson.lwac.http.core.HttpResponseCodeAware;
import com.ericsson.lwac.http.xml.JAXBContextRepository;
import com.ericsson.lwac.http.xml.async.AsyncAdvancedXmlOperation;
import com.ericsson.lwac.http.xml.listener.RequestRecord;
import com.ericsson.lwac.http.xml.listener.RequestResponseListenerManager;
import com.ericsson.lwac.http.xml.listener.ResponseRecord;
import com.ericsson.lwac.transaction.TransactionManager;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncAdvancedXmlOperation<Rq, Rs>
implements AsyncAdvancedXmlOperation<Rq, Rs> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAsyncAdvancedXmlOperation.class);
    @Resource
    private TransactionManager transactionManager;
    @EJB
    private RequestResponseListenerManager requestResponseListenerManager;

    protected AbstractAsyncAdvancedXmlOperation() {
        JAXBContextRepository.registerContext(this.getClass(), Arrays.asList(this.getRequestResponseClasses()));
    }

    @Override
    @Nonnull
    public final CompletableFuture<Void> handleAsync(RequestCorrelationId correlationId, HttpOperationRequest httpOperationRequest, HttpOperationResponse httpOperationResponse) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            Object request;
            int timeout = this.getTransactionTimeout();
            if (timeout > 0) {
                logger.trace("Setting timeout to {} from {}", (Object)timeout, (Object)this.getClass().getName());
                if (this.transactionManager.getTransaction().isPresent()) {
                    this.transactionManager.getTransaction().ifPresent(transaction -> transaction.setTransactionTimeout(timeout, TimeUnit.SECONDS));
                } else {
                    logger.warn("Missing transaction in {}", (Object)this.getClass().getName());
                }
            }
            try {
                request = this.unmarshal(httpOperationRequest);
            }
            catch (UnmarshalException e) {
                throw new HttpBadRequestException("Unable to unmarshal the request", (Throwable)e);
            }
            logger.trace("Request for {} ({})\n{}", this.getName(), httpOperationRequest.getSessionId(), request);
            this.requestResponseListenerManager.publish(new RequestRecord(correlationId, request, httpOperationRequest.getHttpOperationPath(), this.getClass()));
            return this.handleAsync(httpOperationRequest, httpOperationResponse, request).thenAccept(response -> {
                this.requestResponseListenerManager.publish(new ResponseRecord(correlationId, response));
                try {
                    this.marshal(httpOperationResponse, response);
                }
                catch (JAXBException e) {
                    throw new CompletionException(e);
                }
                this.addCustomDataToHttpResponse(httpOperationResponse, response);
            });
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
            return result;
        }
    }

    private void addCustomDataToHttpResponse(HttpOperationResponse httpOperationResponse, Object response) {
        if (response instanceof HttpResponseCodeAware) {
            List headers;
            ((HttpResponseCodeAware)response).getHttpResponseCode().ifPresent(httpOperationResponse::setHttpResponseCode);
            if (response instanceof CustomHttpResponse && (headers = ((CustomHttpResponse)response).getHttpResponseHeaders()) != null) {
                for (HttpHeader header : headers) {
                    httpOperationResponse.addHeader(header.getKey(), header.getValue());
                }
            }
        }
    }

    protected Object unmarshal(HttpOperationRequest httpOperationRequest) throws JAXBException, IOException {
        Unmarshaller unm = JAXBContextRepository.createUnmarshallerFor(this.getClass());
        unm.setSchema(this.getSchema());
        return unm.unmarshal(JAXBContextRepository.createXmlSource(httpOperationRequest.getInputStream()));
    }

    protected void marshal(HttpOperationResponse httpOperationResponse, Object response) throws JAXBException {
        JAXBContextRepository.createMarshallerFor(this.getClass()).marshal(response, httpOperationResponse.getOutputStream());
    }

    @Override
    @Nonnull
    public String getContentType() {
        return "text/xml";
    }

    protected Schema getSchema() {
        return null;
    }

    protected int getTransactionTimeout() {
        return 0;
    }
}

