/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.xml;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class JAXBContextRepository {
    private static final Logger logger = LoggerFactory.getLogger(JAXBContextRepository.class);
    private static final Map<Class<?>, LazyEntry<JAXBContext>> cachedContext = new ConcurrentHashMap();
    private static final ExecutorService loadService = Executors.newSingleThreadExecutor();
    private static SAXParserFactory parserFactory = JAXBContextRepository.createParserFactory();

    private JAXBContextRepository() {
    }

    public static void registerContext(Class<?> owningClass, Class<?> requestClass, Class<?> responseClass) {
        LinkedList classes = new LinkedList();
        if (requestClass != null) {
            classes.add(requestClass);
        }
        if (responseClass != null) {
            classes.add(responseClass);
        }
        JAXBContextRepository.registerContext(owningClass, classes);
    }

    public static void registerContext(Class<?> owningClass, List<Class<?>> classes) {
        if (!cachedContext.containsKey(owningClass)) {
            cachedContext.put(owningClass, new LazyEntry<JAXBContext>(() -> {
                try {
                    return JAXBContext.newInstance(classes.toArray(new Class[0]));
                }
                catch (JAXBException e) {
                    logger.error("Could not load request or response class", e);
                    return null;
                }
            }));
            loadService.submit(() -> cachedContext.get(owningClass).load());
        }
    }

    public static Unmarshaller createUnmarshallerFor(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbContext = cachedContext.get(clazz).get();
        Objects.requireNonNull(jaxbContext);
        return jaxbContext.createUnmarshaller();
    }

    public static Source createXmlSource(InputStream inputStream) {
        SAXSource xmlSource = null;
        try {
            xmlSource = new SAXSource(parserFactory.newSAXParser().getXMLReader(), new InputSource(inputStream));
        }
        catch (ParserConfigurationException | SAXException e) {
            logger.error("Could not create new SAX parser", e);
        }
        return xmlSource;
    }

    public static Marshaller createMarshallerFor(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbContext = cachedContext.get(clazz).get();
        Objects.requireNonNull(jaxbContext);
        return jaxbContext.createMarshaller();
    }

    private static SAXParserFactory createParserFactory() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            logger.error("Could not set features on SAXParserFactory", e);
        }
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
        saxParserFactory.setXIncludeAware(false);
        return saxParserFactory;
    }

    private static final class LazyEntry<T> {
        private final Lock lock = new ReentrantLock();
        private final Supplier<T> supplier;
        private T value;

        private LazyEntry(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public T get() {
            this.load();
            return this.value;
        }

        void load() {
            if (this.value == null) {
                this.lock.lock();
                try {
                    if (this.value == null) {
                        this.value = this.supplier.get();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

