/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.ws.xml;

import com.ericsson.lwac.http.ws.WebSocketOperationSessionData;
import com.ericsson.lwac.http.ws.xml.XmlWebSocketMessagingChannel;
import com.ericsson.lwac.http.ws.xml.XmlWebSocketOperation;
import com.ericsson.lwac.net.ws.WebSocketMessagingChannel;
import com.ericsson.lwac.net.ws.core.WebSocketCloseCode;
import com.ericsson.lwac.net.ws.core.WebSocketSubProtocol;
import com.ericsson.lwac.net.ws.exchange.WebSocketMessage;
import com.ericsson.lwac.net.ws.server.WebSocketEndpointSession;
import com.ericsson.lwac.net.ws.server.WebSocketEndpointSessionBuilder;
import com.ericsson.lwac.net.ws.server.WebSocketServerHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlWebSocketOperationEndpointSession<S extends WebSocketOperationSessionData, In, Out>
implements WebSocketServerHandler,
WebSocketEndpointSession {
    private static final Logger logger = LoggerFactory.getLogger(XmlWebSocketOperationEndpointSession.class);
    private final XmlWebSocketOperation<S, In, Out> operation;
    private final S sessionData;
    private final XmlWebSocketMessagingChannel<Out> xmlChannel;

    public XmlWebSocketOperationEndpointSession(Builder<S, In, Out> builder) {
        this.operation = builder.operation;
        this.sessionData = builder.sessionData;
        this.xmlChannel = this.createWrapperOutputXmlChannel(builder.channel);
        this.operation.onSessionOpen(this.sessionData, this.xmlChannel);
    }

    @Override
    public Optional<WebSocketServerHandler> getHandler() {
        return Optional.of(this);
    }

    @Override
    public void onClose(WebSocketMessagingChannel channel, WebSocketCloseCode webSocketCloseCode) {
        this.operation.onSessionClose(this.sessionData);
    }

    @Override
    public void onReceivedMessage(WebSocketMessagingChannel channel, WebSocketMessage message) {
        try {
            this.operation.onMessage(this.sessionData, this.xmlChannel, this.operation.unmarshal(message));
        }
        catch (IOException | JAXBException e) {
            try {
                channel.close(WebSocketCloseCode.PROTOCOL_ERROR);
            }
            catch (Exception ex) {
                logger.debug("Failure while closing channel due to unmarshalling errors", ex);
            }
        }
    }

    public static <T extends WebSocketOperationSessionData, Mi, Mo> Builder<T, Mi, Mo> newBuilder(T sessionData) {
        Preconditions.checkNotNull(sessionData, "'sessionData' is invalid, can not be null");
        return new Builder(sessionData);
    }

    private XmlWebSocketMessagingChannel<Out> createWrapperOutputXmlChannel(WebSocketMessagingChannel channel) {
        return xmlMessage -> {
            try {
                WebSocketMessage message = this.operation.marshal(xmlMessage);
                channel.sendMessage(message);
            }
            catch (JAXBException e) {
                try {
                    channel.close(WebSocketCloseCode.PROTOCOL_ERROR);
                }
                catch (Exception ex) {
                    logger.debug("Failure while closing channel due to marshalling errors", ex);
                }
            }
        };
    }

    public static final class Builder<T extends WebSocketOperationSessionData, Mi, Mo>
    implements WebSocketEndpointSessionBuilder {
        private final T sessionData;
        private WebSocketMessagingChannel channel;
        private XmlWebSocketOperation<T, Mi, Mo> operation;

        private Builder(T sessionData) {
            this.sessionData = sessionData;
        }

        @Override
        public Builder<T, Mi, Mo> channel(WebSocketMessagingChannel channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public Builder<T, Mi, Mo> subProtocol(WebSocketSubProtocol ignored) {
            return this;
        }

        public Builder<T, Mi, Mo> operation(XmlWebSocketOperation<T, Mi, Mo> operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public WebSocketEndpointSession build() {
            return new XmlWebSocketOperationEndpointSession(this);
        }
    }
}

