/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.types;

import java.io.Serializable;

public final class HttpOperationPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final HttpOperationPath EMPTY = new HttpOperationPath();
    public static final String DEFAULTOPERATIONNAME = "default";
    private final String[] entries;
    private final String requestUri;

    public static HttpOperationPath create(String uri, String queryString) {
        return new HttpOperationPath(HttpOperationPath.processPath(uri), uri + (String)(queryString != null ? "?" + queryString : ""));
    }

    private HttpOperationPath(String[] entries, String requestUri) {
        this.entries = (String[])entries.clone();
        this.requestUri = requestUri;
    }

    private HttpOperationPath() {
        this.entries = new String[0];
        this.requestUri = "";
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getContext() {
        return this.entries.length > 0 ? this.entries[0] : null;
    }

    public String getOperationName() {
        String operationName;
        if (this.entries.length > 1) {
            operationName = this.entries[1];
            if (operationName.isEmpty()) {
                operationName = DEFAULTOPERATIONNAME;
            }
        } else {
            operationName = DEFAULTOPERATIONNAME;
        }
        return operationName;
    }

    public String getSubPathEntry(int i) {
        if (this.entries.length > i + 2) {
            return this.entries[i + 2];
        }
        return null;
    }

    private static String[] processPath(String requestString) {
        if (requestString == null || requestString.isEmpty()) {
            return new String[0];
        }
        String result = requestString;
        while (result.startsWith("/") && result.length() > 1) {
            result = result.substring(1);
        }
        while (result.endsWith("/") && result.length() > 1) {
            result = result.substring(0, result.length() - 1);
        }
        return result.split("/");
    }
}

