/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.statistics;

import com.ericsson.lwac.http.OperationClassInfo;
import com.ericsson.lwac.http.statistics.WaitReportFile;
import java.io.Serializable;

public class OperationUsage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final OperationClassInfo operation;
    private WaitReportFile lastUsedInFile;

    public OperationUsage(OperationClassInfo operation) {
        this.operation = operation;
        this.lastUsedInFile = null;
    }

    public OperationClassInfo getOperationClassNameVersion() {
        return this.operation;
    }

    public String getClassName() {
        return this.operation.getOperationClassName();
    }

    public String getOperationName() {
        return this.operation.getName();
    }

    public String getOperationVersion() {
        return this.operation.getVersion();
    }

    public WaitReportFile getLastUsedInFile() {
        return this.lastUsedInFile;
    }

    public boolean hasBeenUsed() {
        return this.lastUsedInFile != null;
    }

    public boolean isOperationVersion(String operationName, String version) {
        return operationName.equals(this.operation.getName()) && version.equals(this.operation.getVersion());
    }

    public void markUsed(WaitReportFile inFile) {
        if (inFile != null && (this.lastUsedInFile == null || inFile.isAfter(this.lastUsedInFile))) {
            this.lastUsedInFile = inFile;
        }
    }
}

