/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import org.joda.time.DateTime;

public final class Interval
implements Serializable,
Comparable<Interval> {
    private static final long serialVersionUID = 1L;
    private final DateTime from;
    private final DateTime to;

    protected Interval(DateTime f, DateTime t) {
        this.from = f;
        this.to = t;
    }

    public static Interval of(DateTime f, DateTime t) {
        return f.isAfter(t) ? new Interval(t, f) : new Interval(f, t);
    }

    public DateTime start() {
        return this.from;
    }

    public DateTime end() {
        return this.to;
    }

    @Override
    public int compareTo(Interval o) {
        int i = this.from.compareTo(o.from);
        return i == 0 ? this.to.compareTo(o.to) : i;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    public List<Interval> minus(List<Interval> intervals) {
        ArrayList<Interval> list = new ArrayList<Interval>(intervals.size());
        list.addAll(intervals);
        Collections.sort(list);
        return this.minusImpl(list);
    }

    private static boolean afterOrEqual(DateTime left, DateTime right) {
        return left.isAfter(right) || left.equals(right);
    }

    private List<Interval> minusImpl(List<Interval> intervals) {
        List<Object> result;
        if (intervals.isEmpty()) {
            return Collections.singletonList(this);
        }
        Interval head = intervals.remove(0);
        if (Interval.afterOrEqual(this.from, head.from)) {
            if (Interval.afterOrEqual(this.from, head.to)) {
                return this.minusImpl(intervals);
            }
            if (Interval.afterOrEqual(head.to, this.to)) {
                return Collections.emptyList();
            }
            Interval newInterval = Interval.of(head.to, this.to);
            return newInterval.minusImpl(intervals);
        }
        if (Interval.afterOrEqual(head.from, this.to)) {
            return Collections.singletonList(this);
        }
        Interval resultInterval = Interval.of(this.from, head.from);
        if (this.to.isAfter(head.to)) {
            Interval newInterval = Interval.of(head.to, this.to);
            result = newInterval.minusImpl(intervals);
        } else {
            result = Collections.emptyList();
        }
        ArrayList<Interval> list = new ArrayList<Interval>(result.size() + 1);
        list.add(resultInterval);
        list.addAll(result);
        return list;
    }

    public String toString() {
        return String.valueOf(this.from) + "-" + String.valueOf(this.to);
    }

    public static List<Interval> merge(Set<Interval> intervals) {
        ArrayList<Interval> list = new ArrayList<Interval>(intervals.size());
        list.addAll(intervals);
        if (intervals.isEmpty() || intervals.size() == 1) {
            return list;
        }
        Collections.sort(list);
        Interval interval = (Interval)list.remove(0);
        return Interval.merge(interval, list, (end, start) -> Interval.withinOneMinute(end, start));
    }

    private static List<Interval> merge(Interval interval, List<Interval> visitedIntervals, BiPredicate<DateTime, DateTime> sameTime) {
        if (visitedIntervals.isEmpty()) {
            return Collections.singletonList(interval);
        }
        ArrayList<Interval> copy = new ArrayList<Interval>(visitedIntervals.size() + 1);
        copy.addAll(visitedIntervals);
        Optional<Interval> found = copy.stream().filter(i -> sameTime.test(interval.end(), i.start())).findFirst();
        if (found.isPresent()) {
            copy.remove(found.get());
            Interval newInterval = Interval.of(interval.start(), found.get().end());
            List<Interval> merged = Interval.merge(newInterval, copy, sameTime);
            return merged;
        }
        Interval newInterval = (Interval)copy.remove(0);
        List<Interval> merged = Interval.merge(newInterval, copy, sameTime);
        copy.clear();
        copy.add(interval);
        copy.addAll(merged);
        return copy;
    }

    private static boolean withinOneMinute(DateTime end, DateTime start) {
        return Math.abs(start.getMillis() - end.getMillis()) <= 60000L;
    }
}

