/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.statistics;

import com.ericsson.lwac.deployer.MainDeployer;
import com.ericsson.lwac.http.HttpOperation;
import com.ericsson.lwac.http.HttpOperationService;
import com.ericsson.lwac.http.OperationClassInfo;
import com.ericsson.lwac.http.cli.HttpDeprecatedOperationsScanner;
import com.ericsson.lwac.http.statistics.Context;
import com.ericsson.lwac.http.statistics.HttpOperationStatistics;
import com.ericsson.lwac.http.statistics.OperationContextInfo;
import com.ericsson.lwac.http.types.Version;
import com.ericsson.lwac.http.xml.XmlOperation;
import jakarta.annotation.Resource;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpOperationStatisticsBean
implements HttpOperationStatistics {
    private static final Logger logger = LoggerFactory.getLogger(HttpOperationStatisticsBean.class);
    @Resource
    private MainDeployer deployer;

    OperationContextInfo infoFromClass(Class<? extends HttpOperation> operationClass, Map<Context, List<OperationClassInfo>> contextInfo) {
        String className = operationClass.getCanonicalName();
        String operationName = "???";
        String namespace = "";
        try {
            HttpOperation httpOperation = operationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            operationName = httpOperation.getName();
            namespace = this.getNamespace(httpOperation);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException x) {
            logger.info("While instantiating " + operationClass.getCanonicalName(), x);
        }
        LinkedList<Context> contexts = new LinkedList<Context>();
        for (Map.Entry<Context, List<OperationClassInfo>> entry : contextInfo.entrySet()) {
            Context context = entry.getKey();
            List<OperationClassInfo> classInfo = entry.getValue();
            if (!classInfo.stream().filter(i -> className.equals(i.getOperationClassName())).findFirst().isPresent()) continue;
            contexts.add(context);
        }
        return OperationContextInfo.of(className, operationName, HttpDeprecatedOperationsScanner.isDeprecated(operationClass), contexts, namespace);
    }

    private String getNamespace(HttpOperation httpOperation) {
        String namespace = "";
        if (httpOperation instanceof XmlOperation) {
            XmlOperation xmlOperation = (XmlOperation)httpOperation;
            Class<?> requestClass = xmlOperation.getRequestClass();
            XmlRootElement xmlRootElement = null;
            if (requestClass == null) {
                Class<?> responseClass = xmlOperation.getResponseClass();
                if (responseClass != null) {
                    xmlRootElement = responseClass.getAnnotation(XmlRootElement.class);
                }
            } else {
                xmlRootElement = requestClass.getAnnotation(XmlRootElement.class);
            }
            if (xmlRootElement != null) {
                namespace = xmlRootElement.namespace();
            }
        }
        return namespace;
    }

    private <T> List<Class<? extends T>> getAllEjbClassesImplementing(Class<T> ifc) {
        return this.deployer.getAllEjbClasses().stream().filter(c -> ifc.isAssignableFrom((Class<?>)c)).map(c -> c).collect(Collectors.toList());
    }

    private <T> List<T> getAllServicesImplementing(Class<? extends T> ifc) {
        return this.deployer.getAllServices().stream().filter(o -> ifc.isAssignableFrom(o.getClass())).map(o -> ifc.cast(o)).collect(Collectors.toList());
    }

    @Override
    @RolesAllowed(value={"ROLE_ADMIN"})
    public List<OperationContextInfo> getAllOperations() {
        List<Class<HttpOperation>> operations = this.getAllEjbClassesImplementing(HttpOperation.class);
        Map<Context, List<OperationClassInfo>> operationsPerContext = this.getOperationsPerContext();
        return operations.stream().map(o -> this.infoFromClass((Class<? extends HttpOperation>)o, operationsPerContext)).collect(Collectors.toList());
    }

    @Override
    @RolesAllowed(value={"ROLE_ADMIN"})
    public List<OperationContextInfo> getOperationInfoByOperationNameAndVersion(String operationName, String versionString) {
        Version version = new Version(versionString);
        List<OperationContextInfo> result = this.getAllOperations().stream().filter(info -> operationName.equals(info.getOperationName())).filter(info -> version.equals(Version.fromClassName(info.getClassName()))).collect(Collectors.toList());
        return result;
    }

    @Override
    @RolesAllowed(value={"ROLE_ADMIN"})
    public OperationContextInfo getOperationInfoByOperationClass(String className) {
        Optional<OperationContextInfo> result = this.getAllOperations().stream().filter(info -> className.equals(info.getClassName())).findFirst();
        return result.orElse(null);
    }

    private Map<Context, List<OperationClassInfo>> getOperationsPerContext() {
        List<HttpOperationService> httpServices = this.getAllServicesImplementing(HttpOperationService.class);
        TreeMap<Context, List<OperationClassInfo>> operationsPerContext = new TreeMap<Context, List<OperationClassInfo>>();
        httpServices.stream().forEach(s -> operationsPerContext.put(Context.of(s.getContext()), s.getOperationClassInfo()));
        return operationsPerContext;
    }
}

