/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli.domain;

import com.ericsson.lwac.http.cli.domain.HttpService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class ServiceFile
implements Serializable {
    private final String path;
    private final List<HttpService> httpServices;

    private ServiceFile(Builder builder) {
        this.path = builder.path;
        this.httpServices = builder.httpServices;
    }

    public String getPath() {
        return this.path;
    }

    public List<HttpService> getHttpServices() {
        return this.httpServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceFile that = (ServiceFile)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String path;
        private List<HttpService> httpServices = new ArrayList<HttpService>();

        private Builder() {
        }

        public Builder path(String val) {
            this.path = val;
            return this;
        }

        public Builder httpServices(List<HttpService> val) {
            this.httpServices = val;
            return this;
        }

        public Builder addHttpService(HttpService val) {
            this.httpServices.add(val);
            return this;
        }

        public ServiceFile build() {
            return new ServiceFile(this);
        }
    }
}

