/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.ericsson.lwac.utilities.SimpleNamespaceContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class HttpSettingsFileUtils {
    public static final String NS_PROPERTIES = "http://www.ericsson.com/lwac/properties";
    public static final String NS_SERVICES = "http://www.ericsson.com/lwac/services";

    private HttpSettingsFileUtils() {
    }

    public static List<File> getXmlFiles(File rootDir, boolean includeTemplates) throws IOException {
        return HttpSettingsFileUtils.getXmlFiles(rootDir, includeTemplates, false);
    }

    public static List<File> getXmlFiles(File rootDir, final boolean includeTemplates, final boolean includeExternal) throws IOException {
        final LinkedList<File> allFiles = new LinkedList<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                boolean skipExternal;
                String dirName = dir.toFile().getName();
                boolean skipTemplates = dirName.contains("backup") || dirName.contains("template") && !includeTemplates;
                boolean bl = skipExternal = includeExternal && dir.toFile().isHidden() || !includeExternal && (dirName.contains("external") || dirName.contains("-services-"));
                if (skipTemplates || skipExternal) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toFile().getName().endsWith(".xml")) {
                    allFiles.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(allFiles);
        return allFiles;
    }

    public static List<Element> processXPathOn(File file, String xpath) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        return HttpSettingsFileUtils.processXPathOn(file, xpath, false);
    }

    public static List<Element> processXPathOn(File file, String xpath, boolean ignoreWhitespace) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        domFactory.setIgnoringElementContentWhitespace(ignoreWhitespace);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        try (FileInputStream stream = new FileInputStream(file);){
            Document document = builder.parse(stream);
            List<Element> list = HttpSettingsFileUtils.findMultipleElements(xpath, document);
            return list;
        }
    }

    public static XPath newServiceXPath() {
        XPath path = XPathFactory.newInstance().newXPath();
        SimpleNamespaceContext namespaces = new SimpleNamespaceContext();
        namespaces.addNamespace("s", NS_SERVICES);
        namespaces.addNamespace("p", NS_PROPERTIES);
        path.setNamespaceContext(namespaces);
        return path;
    }

    public static List<Node> findMultipleNodes(String xpath, Node root) throws XPathExpressionException {
        XPath path = HttpSettingsFileUtils.newServiceXPath();
        NodeList nodeList = (NodeList)path.evaluate(xpath, root, XPathConstants.NODESET);
        ArrayList<Node> nodes = new ArrayList<Node>(nodeList.getLength());
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    public static List<Element> findMultipleElements(String xpath, Node root) throws XPathExpressionException {
        XPath path = HttpSettingsFileUtils.newServiceXPath();
        NodeList nodeList = (NodeList)path.evaluate(xpath, root, XPathConstants.NODESET);
        ArrayList<Element> nodes = new ArrayList<Element>(nodeList.getLength());
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node item = nodeList.item(i);
            if (item.getNodeType() != 1) {
                throw new IllegalArgumentException("Wrong node type returned for xpath: " + xpath);
            }
            nodes.add((Element)item);
        }
        return nodes;
    }

    public static Node findSingleNode(String xpath, Element root) throws XPathExpressionException {
        XPath path = HttpSettingsFileUtils.newServiceXPath();
        return (Node)path.evaluate(xpath, root, XPathConstants.NODE);
    }

    public static Element findElement(String xpath, Node root) throws XPathExpressionException {
        XPath path = HttpSettingsFileUtils.newServiceXPath();
        Node node = (Node)path.evaluate(xpath, root, XPathConstants.NODE);
        if (node != null && node.getNodeType() != 1) {
            throw new IllegalArgumentException("Wrong node type returned for xpath: " + xpath);
        }
        return (Element)node;
    }
}

