/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.deployer.MainDeployer;
import com.ericsson.lwac.http.cli.HttpContextManager;
import com.ericsson.lwac.http.cli.HttpOperationHelper;
import com.ericsson.lwac.http.cli.domain.ServiceFile;
import com.ericsson.lwac.kubernetes.KubernetesApiClient;
import com.ericsson.lwac.repository.ReadOnlyOfflineRepository;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.Singleton;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Singleton
public class HttpContextManagerBean
implements HttpContextManager {
    private HttpOperationHelper helper;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private KubernetesApiClient apiClient;
    @Resource
    private ReadOnlyOfflineRepository repository;
    @Resource
    private MainDeployer mainDeployer;

    @Override
    @RolesAllowed(value={"ROLE_ADMIN"})
    public String createAll(boolean force) throws IOException {
        return this.helper.createAll(force);
    }

    @Override
    @RolesAllowed(value={"ROLE_ADMIN"})
    public String create(String templateName, String context, String authenticationProvider, String errorHandler, String comment, boolean onlyTemplates, boolean force) throws XPathExpressionException, IOException, ParserConfigurationException, ClassNotFoundException, SAXException {
        return this.helper.create(templateName, context, authenticationProvider, errorHandler, comment, onlyTemplates, force);
    }

    @Override
    @RolesAllowed(value={"ROLE_ADMIN"})
    public List<ServiceFile> getContextServiceFiles(boolean isListProperties, @Nullable String inputContext) throws IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        return this.helper.getContextServiceFiles(isListProperties, inputContext);
    }

    @PostConstruct
    public void postConstruct() {
        this.helper = HttpOperationHelper.newBuilder().apiClient(this.apiClient).applicationName(this.applicationContext.getApplicationName()).rootDir(this.applicationContext.getApplicationRoot()).activeFilter(file -> this.repository.isServiceFileEnabled(file.toPath())).allServiceSettings(this.mainDeployer.getAllServiceSettings()).allOverriddenServiceSettings(this.mainDeployer.getAllOverriddenServiceSettings()).allServiceObjects(this.mainDeployer.getAllServiceObjects()).build();
    }

    public static interface ContextXmlTransformer {
        public Document transform(StringBuilder var1, Document var2) throws XPathExpressionException;
    }
}

