/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.HttpOperation;
import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.RequestCorrelationId;
import com.ericsson.lwac.http.SessionType;
import com.ericsson.lwac.security.session.SessionManager;
import jakarta.annotation.Resource;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import javax.annotation.Nonnull;

@Local(value={HttpOperation.class})
@Singleton
public class LogoutOperation
implements HttpOperation {
    @Resource
    private SessionManager sessionManager;

    @Override
    public void handle(RequestCorrelationId requestCorrelationId, HttpOperationRequest httpOperationRequest, HttpOperationResponse httpOperationResponse) {
        this.sessionManager.logout(httpOperationRequest.getSessionId(), httpOperationRequest.getContext());
    }

    @Override
    @Nonnull
    public SessionType getSessionType() {
        return SessionType.REQUIRES_SESSION;
    }

    @Override
    @Nonnull
    public String getName() {
        return "logout";
    }

    @Override
    @Nonnull
    public String getContentType() {
        return "text/plain";
    }
}

