/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.ContextAuthenticationManager;
import com.ericsson.lwac.security.authentication.AuthenticationProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.ejb.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
public class ContextAuthenticationManagerBean
implements ContextAuthenticationManager {
    private final ConcurrentMap<String, AuthenticationProvider> authenticationProviderMap = new ConcurrentHashMap<String, AuthenticationProvider>();

    @Override
    public void register(String context, AuthenticationProvider authenticationProvider) {
        if (this.authenticationProviderMap.putIfAbsent(context, authenticationProvider) != null) {
            throw new IllegalArgumentException(String.format("Context '%s' already registered", context));
        }
    }

    @Override
    public AuthenticationProvider get(String context) {
        return (AuthenticationProvider)this.authenticationProviderMap.get(context);
    }

    @VisibleForTesting
    public Map<String, AuthenticationProvider> getAuthenticationProviders() {
        return ImmutableMap.copyOf(this.authenticationProviderMap);
    }
}

