/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.BufferedOutputStream;
import com.ericsson.lwac.http.HttpOperationCallContext;
import com.ericsson.lwac.http.trace.HttpTraceService;
import com.ericsson.lwac.net.http.BufferedHttpServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class CallContext
implements HttpOperationCallContext {
    private final HttpTraceService traceService;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private BufferedOutputStream responseOutputStream = new BufferedOutputStream();
    private String sessionId = null;
    private boolean singleCallLogin = false;
    private boolean failure = true;
    private final BufferedHttpServletRequest requestWrapper;

    public CallContext(HttpTraceService traceService, BufferedHttpServletRequest request, HttpServletResponse response) {
        this.traceService = traceService;
        this.request = request;
        this.response = response;
        this.requestWrapper = request;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public boolean isSingleCallLogin() {
        return this.singleCallLogin;
    }

    @Override
    public void setSingleCallLogin(boolean singleCallLogin) {
        this.singleCallLogin = singleCallLogin;
    }

    @Override
    public boolean isFailure() {
        return this.failure;
    }

    @Override
    public void setFailure(boolean failure) {
        this.failure = failure;
    }

    @Override
    public HttpServletRequest getRealRequest() {
        return this.request;
    }

    public HttpServletResponse getRealResponse() {
        return this.response;
    }

    @Override
    public BufferedOutputStream getResponseOutputStream() {
        return this.responseOutputStream;
    }

    @Override
    public void setResponseOutputStream(BufferedOutputStream responseOutputStream) {
        this.responseOutputStream = responseOutputStream;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.requestWrapper;
    }

    @Override
    public void finishResponse() throws IOException {
        this.response.setContentLength(this.getResponseOutputStream().size());
        WritableByteChannel channel = Channels.newChannel(this.response.getOutputStream());
        for (ByteBuffer buf : this.getResponseOutputStream().getBufferList()) {
            channel.write(buf);
        }
        channel.close();
    }

    public BufferedHttpServletRequest getRequestWrapper() {
        return this.requestWrapper;
    }

    @Override
    public void markResponseFinished() {
        this.responseOutputStream.flipBuffers();
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    @Override
    public void setContentType(String mediaType) {
        this.response.setContentType(mediaType);
    }

    @Override
    public void setStatus(int statusCode) {
        this.response.setStatus(statusCode);
        this.traceService.setStatus(statusCode);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    @Override
    public void closeOutputStream() throws IOException {
        this.response.getOutputStream().close();
    }

    @Override
    public void sendRedirect(String redirectUrl) throws IOException {
        this.traceService.setStatus(302);
        this.traceService.setRedirectLocation(redirectUrl);
        this.response.sendRedirect(redirectUrl);
    }
}

