/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.cluster;

import com.ericsson.lwac.cluster.Address;
import com.ericsson.lwac.cluster.ClusterChannel;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterId;
import com.ericsson.lwac.cluster.ClusterMessage;
import com.ericsson.lwac.cluster.ClusterMessageListener;
import com.ericsson.lwac.cluster.ClusterNode;
import com.ericsson.lwac.cluster.ViewChangeListener;
import com.ericsson.lwac.deployer.BeanId;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;

public interface ClusterService {
    public ClusterChannel registerMessageListener(BeanId var1, ClusterMessageListener var2) throws ClusterException;

    public void registerViewChangeListener(ViewChangeListener var1);

    public List<ClusterMessage> castMessage(ClusterChannel var1, Object var2, CastOption var3) throws ClusterException, NotSerializableException;

    public ClusterMessage sendMessage(ClusterChannel var1, Address var2, Object var3, CastOption var4) throws ClusterException, NotSerializableException;

    public Lock getLock(BeanId var1) throws ClusterException;

    public <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> createReplicatedMap(BeanId var1) throws ClusterException;

    default public <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> createReplicatedMap(BeanId beanId, boolean blockingUpdates) throws ClusterException {
        throw new ClusterException("Not implemented");
    }

    default public <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> createReplicatedMap(BeanId beanId, int channelPort) throws ClusterException {
        throw new ClusterException("Not implemented");
    }

    default public <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> createReplicatedMap(BeanId beanId, boolean blockingUpdates, int channelPort) throws ClusterException {
        throw new ClusterException("Not implemented");
    }

    public <K extends Serializable, V extends Serializable> void destroyMap(ConcurrentMap<K, V> var1);

    public List<ClusterNode> getNodes();

    public String getClusterName();

    public ClusterId getLocalId();

    public boolean isCoordinator();

    public static enum CastOption {
        SYNC,
        ASYNC;

    }
}

