/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac;

import com.ericsson.lwac.cli.PasswordReader;
import com.ericsson.lwac.cli.commands.SecretHandler;
import com.ericsson.lwac.deployer.interceptor.InterceptorHelper;
import com.ericsson.lwac.security.HashHandler;
import com.ericsson.lwac.util.SettingsUtils;
import com.ericsson.lwac.versions.VersionFactory;

public final class ObjectHelperFactory {
    private ObjectHelperFactory() {
    }

    public static SettingsUtils createSettingsUtils() {
        return (SettingsUtils)ObjectHelperFactory.create("com.ericsson.lwac.util.SettingsUtilsImpl");
    }

    public static PasswordReader createPasswordReader() {
        return (PasswordReader)ObjectHelperFactory.create("com.ericsson.lwac.cli.PasswordReaderImpl");
    }

    public static HashHandler createHashHandler() {
        return (HashHandler)ObjectHelperFactory.create("com.ericsson.lwac.security.HashHandlerImpl");
    }

    public static InterceptorHelper createInterceptorHelper() {
        return (InterceptorHelper)ObjectHelperFactory.create("com.ericsson.lwac.deployer.interceptor.InterceptorHelperImpl");
    }

    public static SecretHandler createSecretHandler() {
        return (SecretHandler)ObjectHelperFactory.create("com.ericsson.lwac.cli.commands.SecretHandlerImpl");
    }

    public static VersionFactory createVersionFactory() {
        return (VersionFactory)ObjectHelperFactory.create("com.ericsson.lwac.versions.VersionFactoryImpl");
    }

    private static Object create(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }
}

