/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac;

import com.ericsson.lwac.DoNotUse;
import com.ericsson.lwac.ErrorCode;
import org.joda.time.base.AbstractInstant;

@DoNotUse(value="4.0")
public abstract class BaseApplicationException
extends RuntimeException {
    private final ErrorCode errorCode;
    private static final long serialVersionUID = -9129654989488410763L;
    private final Object[] msgFormatArguments;

    public BaseApplicationException(String message, ErrorCode errorCode, Object ... args) {
        super(message);
        this.msgFormatArguments = BaseApplicationException.convertArgs(args);
        this.errorCode = errorCode;
    }

    private static Object[] convertArgs(Object[] args) {
        Object[] copyArgs = new Object[args.length];
        for (Object o : args) {
            if (o instanceof AbstractInstant) {
                o = ((AbstractInstant)o).toDate();
            }
            copyArgs[i] = o;
        }
        return copyArgs;
    }

    public BaseApplicationException(Throwable throwable, ErrorCode errorCode, Object ... args) {
        super(BaseApplicationException.createMessage(errorCode, BaseApplicationException.convertArgs(args)), throwable);
        this.msgFormatArguments = BaseApplicationException.convertArgs(args);
        this.errorCode = errorCode;
    }

    public BaseApplicationException(ErrorCode errorCode, Object ... args) {
        super(BaseApplicationException.createMessage(errorCode, BaseApplicationException.convertArgs(args)));
        this.msgFormatArguments = BaseApplicationException.convertArgs(args);
        this.errorCode = errorCode;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Object[] getArguments() {
        return this.msgFormatArguments;
    }

    private static String createMessage(ErrorCode errorCode, Object ... args) {
        return errorCode.getName() + " " + (errorCode.getNumOfArgs() == args.length ? String.format(errorCode.getMessage(), args) : "");
    }
}

