/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.variable;

import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.CountedObjectRepositoryChangeEvent;
import com.ericsson.ere.util.CountedObjectRepositoryListener;
import ericsson.vareditor.variable.StringVariable;
import javax.swing.text.Document;

public class UniqueStringVariable
extends StringVariable {
    private final CountedObjectRepository<String> myStringRepository;
    private final RepositoryHandler myHandler;
    private boolean myIsDetached;
    private final String myNoValueRegexp;

    public UniqueStringVariable(String label, String value, CountedObjectRepository<String> repository) {
        this(label, value, repository, null);
    }

    public UniqueStringVariable(String label, String value, CountedObjectRepository<String> repository, Document document) {
        this(label, value, repository, document, null);
    }

    public UniqueStringVariable(String label, String value, CountedObjectRepository<String> repository, Document document, String regExp) {
        super(label, value, document);
        this.requireNotNull(repository, "Repository");
        this.requireNotNull(value, "Value");
        this.myNoValueRegexp = regExp;
        this.myStringRepository = repository;
        this.addToRepository(value);
        this.myHandler = this.setupHandler(value, repository);
    }

    private void addToRepository(String value) {
        if (!this.isExempted(value)) {
            this.myStringRepository.add(value, this);
        }
    }

    private void removeFromRepository(String value) {
        this.myStringRepository.remove(value, this);
    }

    private RepositoryHandler setupHandler(String value, CountedObjectRepository<String> repository) {
        RepositoryHandler handler = new RepositoryHandler(value);
        repository.addRepositoryListener(handler);
        return handler;
    }

    private void requireNotNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null.");
        }
    }

    @Override
    protected void setVarValue(String v) {
        this.requireNotNull(v, "String value");
        super.setVarValue(v);
        this.myHandler.handleValueChange(v);
    }

    @Override
    protected void setValueFromDocumentEvent(String value) {
        this.myHandler.handleValueChange(value);
        super.setValueFromDocumentEvent(value);
    }

    @Override
    public boolean isValueValid() {
        boolean valid;
        boolean bl = valid = !this.myIsDetached;
        if (valid && this.myModel instanceof FieldValidation) {
            valid = ((FieldValidation)((Object)this.myModel)).isValid(this.editorHasBeenCreated() ? this.getEditorValue() : this.myValue);
        }
        if (valid && !this.isExempted(this.myValue)) {
            int refCount = this.myStringRepository.getReferenceCount(this.myValue);
            assert (refCount > 0);
            valid = refCount == 1;
        }
        return valid;
    }

    private boolean isExempted(String value) {
        return this.myNoValueRegexp != null && value.matches(this.myNoValueRegexp);
    }

    @Override
    public void setModel(Document document) {
        throw new UnsupportedOperationException("UniqueStringVariable doesn't support changing the model.");
    }

    private void checkRepository() {
        if (this.myIsDetached) {
            throw new IllegalStateException("This UniqueStringVariable has been detached.");
        }
    }

    public void detachFromRepository() {
        this.checkRepository();
        this.myStringRepository.removeRepositoryListener(this.myHandler);
        this.removeFromRepository(this.myValue);
        this.myIsDetached = true;
    }

    public void attachToRepository() {
        if (!this.myIsDetached) {
            throw new IllegalStateException("This UniqueStringVariable is already attached to the repository.");
        }
        this.myIsDetached = false;
        this.addToRepository(this.myValue);
        this.myStringRepository.addRepositoryListener(this.myHandler);
    }

    private class RepositoryHandler
    implements CountedObjectRepositoryListener<String> {
        private String myOldValue;
        private boolean myIsUpdatingRepo;

        RepositoryHandler(String value) {
            this.myOldValue = value;
        }

        void handleValueChange(String newValue) {
            UniqueStringVariable.this.checkRepository();
            if (!newValue.equals(this.myOldValue)) {
                this.myIsUpdatingRepo = true;
                try {
                    UniqueStringVariable.this.removeFromRepository(this.myOldValue);
                    UniqueStringVariable.this.addToRepository(newValue);
                    this.myOldValue = newValue;
                }
                finally {
                    this.myIsUpdatingRepo = false;
                }
            }
        }

        @Override
        public void repositoryChanged(CountedObjectRepositoryChangeEvent<String> event) {
            String textInRepository = event.getObject();
            if (!this.myIsUpdatingRepo && textInRepository.equals(UniqueStringVariable.this.myValue) && !UniqueStringVariable.this.isExempted(UniqueStringVariable.this.myValue)) {
                UniqueStringVariable.this.fireValueChanged(UniqueStringVariable.this.myValue, UniqueStringVariable.this.myValue, UniqueStringVariable.this.isValueValid());
            }
        }
    }
}

