/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import ericsson.ere.gui.util.ArrayListModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public abstract class ValidItemList<T>
extends AbstractList<T>
implements ListModel {
    public static final String PROP_VALID = "valid";
    private static final Object VALUE = new Object();
    private ArrayListModel<T> myList = new ArrayListModel();
    private Map<T, Object> myInvalidItems = new IdentityHashMap<T, Object>();
    private PropertyChangeSupport myPropertyListeners = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myPropertyListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myPropertyListeners.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isValid() {
        return this.myInvalidItems.isEmpty();
    }

    public List<T> getInvalidItems() {
        ArrayList invalid = new ArrayList();
        for (Object v : this) {
            if (!this.myInvalidItems.containsKey(v)) continue;
            invalid.add(v);
        }
        return invalid;
    }

    @Override
    public int getSize() {
        return this.myList.getSize();
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.myList.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.myList.removeListDataListener(l);
    }

    @Override
    public T get(int index) {
        return this.myList.get(index);
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public T set(int index, T element) {
        T old = this.myList.set(index, element);
        this.unregister(old);
        this.register(element);
        return old;
    }

    @Override
    public void add(int index, T element) {
        this.register(element);
        this.myList.add(index, element);
    }

    @Override
    public T remove(int index) {
        T old = this.myList.remove(index);
        this.unregister(old);
        return old;
    }

    protected abstract boolean isValid(T var1);

    protected abstract void registerValidStateChangeListener(T var1);

    protected abstract void unregisterValidStateChangeListener(T var1);

    protected void register(T item) {
        if (!this.isValid(item)) {
            this.setInvalid(item);
        }
        this.registerValidStateChangeListener(item);
    }

    protected void unregister(T item) {
        this.setValid(item);
        this.unregisterValidStateChangeListener(item);
    }

    protected void validStateChanged(T item, boolean isValid) {
        if (isValid) {
            this.setValid(item);
        } else {
            this.setInvalid(item);
        }
    }

    private void setInvalid(T var) {
        boolean wasValid = this.isValid();
        this.myInvalidItems.put(var, VALUE);
        boolean isValid = this.isValid();
        this.fireValidChangeIfNecessary(wasValid, isValid);
    }

    private void setValid(T var) {
        boolean wasValid = this.isValid();
        this.myInvalidItems.remove(var);
        boolean isValid = this.isValid();
        this.fireValidChangeIfNecessary(wasValid, isValid);
    }

    private void fireValidChangeIfNecessary(boolean wasValid, boolean isValid) {
        if (wasValid != isValid) {
            this.myPropertyListeners.firePropertyChange(PROP_VALID, wasValid, isValid);
        }
    }
}

