/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.ReadUntilDataCollector;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadUntilHandler
extends DefaultHandler {
    private ReadUntilDataCollector myDataCollector;
    private Stack<String> myElementNameStack;
    private Map<String, StringBuilder> myElementTextValueBuilder;

    public ReadUntilHandler(ReadUntilDataCollector dataCollector) {
        this.myDataCollector = dataCollector;
        this.myElementTextValueBuilder = new HashMap<String, StringBuilder>();
        this.myElementNameStack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        StringBuilder elementTextValueBuilder = new StringBuilder();
        this.myElementTextValueBuilder.put(qName, elementTextValueBuilder);
        this.myElementNameStack.push(qName);
        if (this.myDataCollector.shouldStopReading()) {
            throw new BuildFinishedException();
        }
        if (this.myDataCollector.shouldCollectElement(qName)) {
            this.myDataCollector.collectAttributes(qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = String.valueOf(ch, start, length);
        String currentElementName = this.myElementNameStack.peek();
        StringBuilder builder = this.myElementTextValueBuilder.get(currentElementName);
        builder.append(value);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentElementName = this.myElementNameStack.pop();
        if (this.myDataCollector.shouldCollectElement(currentElementName)) {
            String elementTextValue = this.myElementTextValueBuilder.get(currentElementName).toString();
            this.myDataCollector.collectElementTextValue(currentElementName, elementTextValue);
        }
        this.myElementTextValueBuilder.remove(currentElementName);
    }

    public static class BuildFinishedException
    extends SAXException {
        BuildFinishedException() {
        }
    }
}

