/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Maps {
    private static final Class<?> UNMODIFIABLE_CLASS = Collections.unmodifiableMap(Collections.EMPTY_MAP).getClass();
    private static final Class<?> EMPTY_CLASS = Collections.emptyMap().getClass();
    private static final Class<?> SINGLETON_CLASS = Collections.singletonMap(new Object(), new Object()).getClass();

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (Maps.isUnmodifiable(map)) {
            return map;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static boolean isUnmodifiable(Map<?, ?> map) {
        Class<?> classModel = map.getClass();
        return classModel == UNMODIFIABLE_CLASS | classModel == EMPTY_CLASS | classModel == SINGLETON_CLASS;
    }
}

