/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.io.IOCloser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HttpCommunicator {
    private static Map<Integer, String> myHttpCodeTranslations = new HashMap<Integer, String>();
    protected InputStream myInput;
    protected OutputStream myOutput;
    protected String myCharacterSet;
    private static final String UTF8_CHARSET = "UNICODE-1-1-UTF-8";

    protected HttpCommunicator(Socket socket) throws IOException {
        this.myInput = new BufferedInputStream(socket.getInputStream(), 65536);
        this.myOutput = new BufferedOutputStream(socket.getOutputStream(), 65536);
    }

    protected HttpCommunicator(Socket socket, String charset) throws IOException {
        this(socket);
        this.myCharacterSet = charset;
    }

    protected int getContentLength(Map<String, String> header) {
        if (header != null && header.containsKey("content-length")) {
            return Integer.parseInt(header.get("content-length"));
        }
        return -1;
    }

    protected Map<String, String> readHeader() throws IOException {
        String tmpStr;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        boolean firstLine = true;
        AsciiStreamLineReader reader = new AsciiStreamLineReader(this.myInput, true);
        while ((tmpStr = this.readAsciiLine(reader)) != null && tmpStr.length() != 0) {
            if (firstLine) {
                this.parseFirstLine(headers, tmpStr);
                firstLine = false;
                continue;
            }
            int separator = tmpStr.indexOf(":");
            if (separator <= 0) continue;
            String key = tmpStr.substring(0, separator).trim();
            String value = tmpStr.substring(separator + 1).trim();
            headers.put(key, value);
            headers.put(key.toLowerCase(), value);
        }
        return headers;
    }

    private void parseFirstLine(Map<String, String> headers, String line) throws IOException, UnsupportedEncodingException {
        if (line.startsWith("HTTP")) {
            if (line.charAt(8) != ' ' || line.charAt(12) != ' ') {
                throw new IOException("First HTTP request/response line should contain HTTP version and HTTP status code, was: " + line);
            }
            headers.put("http_version", line.substring(5, 8));
            headers.put("http_code", line.substring(9, 12));
        } else {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                throw new IOException("First HTTP request/response line should contain three parts: " + line);
            }
            headers.put("http_method", parts[0]);
            headers.put("http_uri", URLDecoder.decode(parts[1], "ASCII"));
            headers.put("http_version", parts[2].substring(5));
        }
    }

    private String readAsciiLine(AsciiStreamLineReader reader) throws IOException {
        String s = reader.readAsciiLine();
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    protected void writeOut(StringBuffer buf, String row, boolean isHeader) throws IOException {
        int len;
        int CHUNKSIZE = 32768;
        byte[] octets = this.stringToBytes(row);
        for (int offs = 0; offs < octets.length; offs += len) {
            if (Thread.interrupted()) {
                throw HttpCommunicator.interruptedIO(offs);
            }
            len = octets.length - offs;
            if (len > 32768) {
                len = 32768;
            }
            this.myOutput.write(octets, offs, len);
        }
        if (isHeader) {
            this.myOutput.write(13);
            this.myOutput.write(10);
        }
        if (buf != null) {
            buf.append(row + "\n");
        }
    }

    protected String readBody(int size) throws IOException {
        String body = "";
        assert (size >= 0) : "No size specified, don't know how much to read.";
        if (size != 0) {
            int n;
            int nread;
            byte[] allData = new byte[size];
            for (n = 0; n < size; n += nread) {
                if (Thread.interrupted()) {
                    throw HttpCommunicator.interruptedIO(n);
                }
                nread = this.myInput.read(allData, n, size - n);
                if (nread < 0) break;
            }
            if (n < size) {
                throw new IOException("Failed to read " + size + " bytes of data, got " + n + " bytes.");
            }
            body = this.bytesToString(allData);
        }
        return body;
    }

    private static IOException interruptedIO(int n) throws IOException {
        InterruptedIOException e = new InterruptedIOException("Interrupted during I/O.");
        e.bytesTransferred = n;
        throw e;
    }

    protected Map<String, String> headerArrayToMap(String ... headers) {
        if (headers.length % 2 == 1) {
            throw new IllegalArgumentException("Uneven number of header names/values.");
        }
        LinkedHashMap<String, String> hs = new LinkedHashMap<String, String>();
        for (int i = 0; i < headers.length; i += 2) {
            hs.put(headers[i], headers[i + 1]);
        }
        return hs;
    }

    protected byte[] stringToBytes(String str) throws UnsupportedEncodingException {
        if (this.myCharacterSet == null) {
            return str.getBytes();
        }
        return str.getBytes(this.myCharacterSet);
    }

    protected String bytesToString(byte[] bytes) throws UnsupportedEncodingException {
        if (this.myCharacterSet == null) {
            return new String(bytes);
        }
        return new String(bytes, this.myCharacterSet);
    }

    public abstract Map<String, String> getLatestHeaders();

    public void close() {
        IOCloser.closeIgnoringException(this.myOutput);
        IOCloser.closeIgnoringException(this.myInput);
    }

    static {
        myHttpCodeTranslations.put(100, "Continue");
        myHttpCodeTranslations.put(101, "Switching Protocols");
        myHttpCodeTranslations.put(200, "OK");
        myHttpCodeTranslations.put(201, "Created");
        myHttpCodeTranslations.put(202, "Accepted");
        myHttpCodeTranslations.put(203, "Non-Authoritative Information");
        myHttpCodeTranslations.put(204, "No Content");
        myHttpCodeTranslations.put(205, "Reset Content");
        myHttpCodeTranslations.put(206, "Partial Content");
        myHttpCodeTranslations.put(300, "Multiple Choices");
        myHttpCodeTranslations.put(301, "Moved Permanently");
        myHttpCodeTranslations.put(302, "Moved Temporarily");
        myHttpCodeTranslations.put(303, "See Other");
        myHttpCodeTranslations.put(304, "Not Modified");
        myHttpCodeTranslations.put(305, "Use Proxy");
        myHttpCodeTranslations.put(400, "Bad Request");
        myHttpCodeTranslations.put(401, "Unauthorized");
        myHttpCodeTranslations.put(402, "Payment Required");
        myHttpCodeTranslations.put(403, "Forbidden");
        myHttpCodeTranslations.put(404, "Not Found");
        myHttpCodeTranslations.put(405, "Method Not Allowed");
        myHttpCodeTranslations.put(406, "None Acceptable");
        myHttpCodeTranslations.put(407, "Proxy Authentication Required");
        myHttpCodeTranslations.put(408, "Request Timeout");
        myHttpCodeTranslations.put(409, "Conflict");
        myHttpCodeTranslations.put(410, "Gone");
        myHttpCodeTranslations.put(411, "Length Required");
        myHttpCodeTranslations.put(412, "Unless True");
        myHttpCodeTranslations.put(500, "Internal Server Error");
        myHttpCodeTranslations.put(501, "Not Implemented");
        myHttpCodeTranslations.put(502, "Bad Gateway");
        myHttpCodeTranslations.put(503, "Service Unavailable");
        myHttpCodeTranslations.put(504, "Gateway Timeout");
    }

    @Deprecated
    public static class ExtendedInputStream
    extends InputStream {
        private InputStream myStream;
        private int myPutBack = -1;
        private boolean mySkipNextLF;

        public ExtendedInputStream(InputStream stream) {
            this.myStream = stream;
        }

        @Override
        public int read() throws IOException {
            if (this.myPutBack >= 0) {
                int tmp = this.myPutBack;
                this.myPutBack = -1;
                return tmp;
            }
            int x = this.myStream.read();
            if (this.mySkipNextLF && x == 10) {
                x = this.myStream.read();
            }
            this.mySkipNextLF = false;
            return x;
        }

        public void putBack(int x) throws IOException {
            if (this.myPutBack >= 0) {
                throw new IOException("Cannot put back more than one byte at a time.");
            }
            if (x < 0) {
                throw new IllegalArgumentException("Cannot put back EOF.");
            }
            this.myPutBack = x;
        }

        public byte[] readByteLine() throws IOException {
            ArrayList<Byte> bytes = new ArrayList<Byte>(80);
            int x;
            while ((x = this.read()) >= 0) {
                if (x == 10 || x == 13) {
                    if (x == 13) {
                        if (this.available() > 0) {
                            int next = this.read();
                            if (next != 10 && next >= 0) {
                                this.putBack(next);
                            }
                        } else {
                            this.mySkipNextLF = true;
                        }
                    }
                    byte[] result = new byte[bytes.size()];
                    for (int i = 0; i < bytes.size(); ++i) {
                        result[i] = (Byte)bytes.get(i);
                    }
                    return result;
                }
                bytes.add((byte)x);
            }
            return null;
        }

        @Override
        public int available() throws IOException {
            return this.myPutBack >= 0 ? 1 : super.available();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            super.close();
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }

    static class AsciiStreamLineReader {
        private InputStream myStream;
        private boolean mySkipNextLF = false;
        private boolean myExpectCRLF;

        public AsciiStreamLineReader(InputStream is, boolean expectCRLF) {
            this.myStream = is;
            this.myExpectCRLF = expectCRLF;
        }

        boolean nextMightBeLF() {
            return this.mySkipNextLF;
        }

        String readAsciiLine() throws IOException {
            int i;
            StringBuffer buf = new StringBuffer();
            boolean waitingForLF = false;
            while ((i = this.myStream.read()) != -1) {
                if (Thread.interrupted()) {
                    throw HttpCommunicator.interruptedIO(buf.length());
                }
                if (i == 10 && this.mySkipNextLF) {
                    this.mySkipNextLF = false;
                    continue;
                }
                buf.append((char)i);
                if (i == 13) {
                    if (this.myExpectCRLF) {
                        waitingForLF = true;
                        continue;
                    }
                    this.mySkipNextLF = true;
                    break;
                }
                if (i == 10 && waitingForLF) {
                    waitingForLF = false;
                    break;
                }
                if (!waitingForLF) continue;
                waitingForLF = false;
            }
            return buf.toString();
        }

        boolean shouldSkipNextLF() {
            return this.mySkipNextLF;
        }

        int read() throws IOException {
            int i = this.myStream.read();
            if (i == 10 && this.mySkipNextLF) {
                this.mySkipNextLF = false;
            }
            return i;
        }
    }

    public static class HttpClientCommunicator
    extends HttpCommunicator {
        private String myUserAgent = "ERE HTTP Client/1.0";
        private Map<String, String> myLatestHeaders = null;

        public HttpClientCommunicator(Socket socket) throws IOException {
            super(socket);
        }

        public HttpClientCommunicator(Socket socket, String charset) throws IOException {
            super(socket, charset);
        }

        public void setUserAgent(String userAgent) {
            this.myUserAgent = userAgent;
        }

        public String readResponse() throws IOException {
            Map<String, String> header = this.readHeader();
            this.myLatestHeaders = header;
            int size = this.getContentLength(header);
            if (size < 0) {
                throw new IOException("No content-length in HTTP header: " + String.valueOf(header));
            }
            return this.readBody(size);
        }

        public void sendPostRequest(String uri, String request, String contentType, Map<String, String> headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendPostRequest(null, uri, request, contentType, headers);
        }

        public void sendPostRequest(StringBuffer buf, String uri, String request, String contentType, String ... headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendPostRequest(buf, uri, request, contentType, this.headerArrayToMap(headers));
        }

        public void sendPostRequest(String uri, String request, String contentType, String ... headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendPostRequest((StringBuffer)null, uri, request, contentType, headers);
        }

        public void sendPostRequest(StringBuffer buf, String uri, String request, String contentType, Map<String, String> headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            String ctype;
            String string = ctype = contentType == null || "".equals(contentType) ? null : contentType;
            if (ctype == null) {
                for (String key : headers.keySet()) {
                    if (!"content-type".equalsIgnoreCase(key)) continue;
                    ctype = headers.get(key);
                    break;
                }
            }
            if (ctype == null) {
                throw new IllegalArgumentException("Content type is neither given as parameter nor HTTP header.");
            }
            this.sendRequest(buf, uri, "POST", request, ctype, headers);
        }

        public void sendGetRequest(String uri, Map<String, String> headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendRequest(null, uri, "GET", null, null, headers);
        }

        public void sendGetRequest(String uri, String ... headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendGetRequest((StringBuffer)null, uri, headers);
        }

        public void sendGetRequest(StringBuffer buf, String uri, String ... headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendGetRequest(buf, uri, this.headerArrayToMap(headers));
        }

        public void sendGetRequest(StringBuffer buf, String uri, Map<String, String> headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            this.sendRequest(buf, uri, "GET", null, null, headers);
        }

        private void sendRequest(StringBuffer buf, String uri, String method, String request, String contentType, Map<String, String> headers) throws UnsupportedEncodingException, IOException, IllegalArgumentException {
            String host = null;
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (!"host".equalsIgnoreCase(header.getKey())) continue;
                host = header.getValue();
                break;
            }
            if (host == null) {
                throw new IllegalArgumentException("HTTP header Host is missing.");
            }
            boolean isUTF8 = "UTF-8".equalsIgnoreCase(this.myCharacterSet);
            this.writeOut(buf, method + " " + URLEncoder.encode(uri, "ASCII") + " HTTP/1.1", true);
            this.writeOut(buf, "Host: " + host, true);
            this.writeOut(buf, "Date: " + new Date(), true);
            this.writeOut(buf, "User-Agent: " + this.myUserAgent, true);
            String ac = "us-ascii";
            if (isUTF8) {
                ac = ac + ", UNICODE-1-1-UTF-8";
            }
            this.writeOut(buf, "Accept-Charset: " + ac, true);
            int requestLen = request != null ? this.stringToBytes(request).length : 0;
            this.writeOut(buf, "Content-Length: " + requestLen, true);
            if (contentType != null) {
                String ct = contentType;
                if (isUTF8) {
                    ct = ct + "; charset=UNICODE-1-1-UTF-8";
                }
                this.writeOut(buf, "Content-Type: " + ct, true);
            }
            for (String key : headers.keySet()) {
                if ("host".equalsIgnoreCase(key) || "content-type".equalsIgnoreCase(key) || "content-length".equalsIgnoreCase(key) || "date".equalsIgnoreCase(key) || "server".equalsIgnoreCase(key)) continue;
                this.writeOut(buf, key + ": " + headers.get(key), true);
            }
            this.writeOut(buf, "", true);
            if (request != null) {
                this.writeOut(buf, request, false);
            }
            this.myOutput.flush();
        }

        @Override
        public Map<String, String> getLatestHeaders() {
            return this.myLatestHeaders == null ? null : Collections.unmodifiableMap(this.myLatestHeaders);
        }
    }

    public static class HttpServerCommunicator
    extends HttpCommunicator {
        private String myServerName = "ERE HTTP Server/1.0";
        private String myClientHttpVersion = "";
        private Map<String, String> myLatestHeaders = null;

        public HttpServerCommunicator(Socket socket) throws IOException {
            super(socket);
        }

        public HttpServerCommunicator(Socket socket, String charset) throws IOException {
            super(socket, charset);
        }

        public void setServerName(String serverName) {
            this.myServerName = serverName;
        }

        public void sendResponse(int httpCode, String contentType, String response) throws IOException, IllegalArgumentException {
            this.sendResponse(null, httpCode, contentType, response);
        }

        public void sendResponse(StringBuffer buf, int httpCode, String contentType, String response) throws IOException, IllegalArgumentException {
            String codeString = (String)myHttpCodeTranslations.get(httpCode);
            if (codeString == null) {
                throw new IllegalArgumentException("Unknown HTTP code: " + httpCode);
            }
            String version = this.myClientHttpVersion.equals("") ? "1.0" : this.myClientHttpVersion;
            this.writeOut(buf, "HTTP/" + version + " " + httpCode + " " + codeString, true);
            this.writeOut(buf, "Date: " + new Date(), true);
            this.writeOut(buf, "Server: " + this.myServerName, true);
            int responseLen = this.stringToBytes(response).length;
            this.writeOut(buf, "Content-Length: " + responseLen, true);
            String ct = contentType;
            if ("UTF-8".equalsIgnoreCase(this.myCharacterSet) && !ct.contains(HttpCommunicator.UTF8_CHARSET)) {
                ct = ct + "; charset=UNICODE-1-1-UTF-8";
            }
            this.writeOut(buf, "Content-Type: " + ct, true);
            this.writeOut(buf, "", true);
            this.writeOut(buf, response, false);
            this.myOutput.flush();
        }

        public String readRequest() throws IOException {
            Map<String, String> header = this.readHeader();
            if (header.containsKey("http_version")) {
                this.myClientHttpVersion = header.get("http_version");
            }
            this.myLatestHeaders = header;
            int size = this.getContentLength(header);
            if (size < 0) {
                throw new IOException("No content-length in HTTP header: " + String.valueOf(header));
            }
            return this.readBody(size);
        }

        public String getClientHttpVersion() {
            return this.myClientHttpVersion;
        }

        @Override
        public Map<String, String> getLatestHeaders() {
            return this.myLatestHeaders == null ? null : Collections.unmodifiableMap(this.myLatestHeaders);
        }
    }
}

