/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.datatype.ValueResolver;
import ericsson.ere.datatype.ContextBasedValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;

public class FieldDefinitionUtil {
    public static Object createDefaultInstance(FieldDefinition aDef) {
        if (aDef == null) {
            return null;
        }
        return FieldDefinitionUtil.createValueResolver(null, aDef).createDefaultInstance();
    }

    public static String makeValueString(Object anObject, FieldDefinition aDef) {
        if (aDef == null) {
            return null;
        }
        return FieldDefinitionUtil.createValueResolver(null, aDef).makeValueString(anObject);
    }

    public static String makeDisplayString(Object anObject, FieldDefinition aDef) {
        if (aDef == null) {
            return null;
        }
        return FieldDefinitionUtil.createValueResolver(null, aDef).makeDisplayString(anObject);
    }

    public static ValueResolver createValueResolver(ClassRepository repository, FieldDefinition field) {
        if (field == null) {
            throw new IllegalArgumentException("Field is required.");
        }
        ContextBasedValueResolver cresolver = DataType.createTypeIndependentContextBasedValueResolver().withFieldDefinition(field);
        if (repository != null) {
            cresolver = cresolver.withClassRepository(repository);
        }
        return cresolver.finish();
    }

    public static boolean areFieldsUsingSameValueClassAndDataType(FieldDefinition aField, FieldDefinition anotherField) {
        DataType firstType = aField != null ? aField.getTypedDataType() : null;
        DataType secondType = anotherField.getTypedDataType();
        return FieldDefinitionUtil.areFieldsUsingSameValueClass(aField, anotherField) && firstType == secondType;
    }

    public static boolean areFieldsUsingSameValueClass(FieldDefinition aField, FieldDefinition anotherField) {
        Class<?> firstClass = aField != null && aField.hasValueClass() ? aField.getValueClassProper() : null;
        Class<?> secondClass = anotherField.hasValueClass() ? anotherField.getValueClassProper() : null;
        return firstClass == secondClass;
    }
}

