/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import com.ericsson.ere.util.Predicate;
import java.util.List;

public class BooleanPredicate<T>
implements Predicate<T> {
    private Operation myOp;
    private Predicate<T>[] myPred;

    public BooleanPredicate(Operation op, List<? extends Predicate<T>> predicates) {
        if (op == null) {
            throw new IllegalArgumentException("Null operation not permitted.");
        }
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException("Boolean operation requires at least one predicate.");
        }
        if (op == Operation.NOT && predicates.size() > 1) {
            throw new IllegalArgumentException("NOT operation requires a single predicate.");
        }
        this.myOp = op;
        this.myPred = predicates.toArray(new Predicate[predicates.size()]);
    }

    @Override
    public boolean test(T node) {
        boolean result;
        int len = this.myPred.length;
        switch (this.myOp) {
            case AND: {
                Predicate<T> p;
                result = true;
                for (int i = 0; i < len && (result = (p = this.myPred[i]).test(node)); ++i) {
                }
                break;
            }
            case OR: {
                Predicate<T> p;
                result = false;
                for (int i = 0; i < len && !(result = (p = this.myPred[i]).test(node)); ++i) {
                }
                break;
            }
            case NOT: {
                Predicate<T> p = this.myPred[0];
                result = !p.test(node);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown operation: " + (Object)((Object)this.myOp)));
            }
        }
        return result;
    }

    public static enum Operation {
        AND,
        OR,
        NOT;

    }
}

