/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class AggregatedCollection<E>
extends AbstractCollection<E> {
    private final Collection<E>[] myCollections;

    public AggregatedCollection(Collection<E> ... collections) {
        ArrayList<Collection<E>> cl = new ArrayList<Collection<E>>(collections.length);
        for (Collection<E> c : collections) {
            if (c == null) continue;
            cl.add(c);
        }
        if (cl.isEmpty()) {
            throw new IllegalArgumentException("No collections to aggregate.");
        }
        this.myCollections = cl.toArray(new Collection[cl.size()]);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> c : this.myCollections) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean add(E e) {
        Collection<E> last = this.myCollections[this.myCollections.length - 1];
        return last.add(e);
    }

    private class Itr
    implements Iterator<E> {
        private Iterator<E>[] myIterators;
        private int myIndex = 0;

        Itr() {
            ArrayList iterators = new ArrayList();
            for (Collection c : AggregatedCollection.this.myCollections) {
                Iterator it = c.iterator();
                if (!it.hasNext()) continue;
                iterators.add(it);
            }
            this.myIterators = iterators.toArray(new Iterator[iterators.size()]);
        }

        @Override
        public boolean hasNext() {
            if (this.myIndex >= this.myIterators.length) {
                return false;
            }
            if (this.myIterators[this.myIndex].hasNext()) {
                return true;
            }
            if (this.myIndex >= this.myIterators.length - 1) {
                return false;
            }
            return this.myIterators[this.myIndex + 1].hasNext();
        }

        @Override
        public E next() {
            if (this.myIndex >= this.myIterators.length) {
                throw new NoSuchElementException();
            }
            Object elem = null;
            try {
                elem = this.myIterators[this.myIndex].next();
            }
            catch (NoSuchElementException e) {
                if (this.myIndex >= this.myIterators.length - 1) {
                    throw e;
                }
                elem = this.myIterators[++this.myIndex].next();
            }
            return elem;
        }

        @Override
        public void remove() {
            if (this.myIndex >= this.myIterators.length) {
                throw new IllegalStateException("Nothing to remove.");
            }
            this.myIterators[this.myIndex].remove();
        }
    }
}

