/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace.filter;

import com.ericsson.ere.trace.filter.AbstractTraceFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PlainTextTraceFilter
extends AbstractTraceFilter {
    private List<String> myTableColumns = new ArrayList<String>();
    private List<List<String>> myTableRows = new ArrayList<List<String>>();
    private List<String> myTableRow = new ArrayList<String>();
    private static final String myHorizontalLine = "-------------------------------------------------------------------------";
    private int myHeaderLength = 0;

    @Override
    protected void print(String parString, PrintWriter parWriter) {
        if (this.myIsHeader) {
            this.myHeaderLength += parString.length();
        }
        if (this.myIsTableHeader) {
            this.myTableColumns.add(parString);
        } else if (this.myIsTableCell) {
            this.myTableRow.add(parString);
        } else {
            parWriter.print(parString);
        }
    }

    @Override
    protected void beginBold(PrintWriter parWriter) {
    }

    @Override
    protected void endBold(PrintWriter parWriter) {
    }

    @Override
    protected void beginItalic(PrintWriter parWriter) {
    }

    @Override
    protected void endItalic(PrintWriter parWriter) {
    }

    @Override
    protected void beginMonospace(PrintWriter parWriter) {
    }

    @Override
    protected void endMonospace(PrintWriter parWriter) {
    }

    @Override
    protected void beginTable(PrintWriter parWriter) {
        parWriter.println();
    }

    @Override
    protected void beginTableHeader(PrintWriter parWriter) {
    }

    @Override
    protected void endTableHeader(PrintWriter parWriter) {
    }

    @Override
    protected void beginTableRow(PrintWriter parWriter) {
        this.myTableRow = new ArrayList<String>();
    }

    @Override
    protected void beginTableCell(PrintWriter parWriter) {
    }

    @Override
    protected void endTableCell(PrintWriter parWriter) {
    }

    @Override
    protected void endTableRow(PrintWriter parWriter) {
        this.myTableRows.add(this.myTableRow);
    }

    @Override
    protected void endTable(PrintWriter parWriter) {
        int i;
        int theNumberOfColumns = this.myTableColumns.size();
        for (int i2 = 0; i2 < this.myTableRows.size(); ++i2) {
            List<String> theRow = this.myTableRows.get(i2);
            theNumberOfColumns = Math.max(theNumberOfColumns, theRow.size());
        }
        int[] theColumnWidths = new int[theNumberOfColumns];
        for (int i3 = 0; i3 < theNumberOfColumns; ++i3) {
            theColumnWidths[i3] = this.getColumnWidth(i3);
        }
        int theColumnIndex = 0;
        for (i = 0; i < this.myTableColumns.size(); ++i) {
            String theColumn = this.myTableColumns.get(i);
            parWriter.print(theColumn);
            for (int k = 0; k < theColumnWidths[theColumnIndex] - theColumn.length(); ++k) {
                parWriter.write(32);
            }
            ++theColumnIndex;
        }
        parWriter.println();
        for (i = 0; i < theNumberOfColumns; ++i) {
            for (int j = 0; j < theColumnWidths[i] - 2; ++j) {
                parWriter.write(45);
            }
            parWriter.write("  ");
        }
        for (i = 0; i < this.myTableRows.size(); ++i) {
            List<String> theRow = this.myTableRows.get(i);
            theColumnIndex = 0;
            for (int j = 0; j < theRow.size(); ++j) {
                String theCell = theRow.get(j);
                for (int k = 0; k < theColumnWidths[theColumnIndex] - theCell.length() - 2; ++k) {
                    parWriter.write(32);
                }
                parWriter.print(theCell);
                parWriter.write(32);
                parWriter.write(32);
                ++theColumnIndex;
            }
            parWriter.println();
        }
        this.myTableColumns.clear();
        this.myTableRows.clear();
        parWriter.println();
    }

    private int getColumnWidth(int parColumn) {
        int theColumnWidth = 0;
        if (parColumn >= 0 && parColumn < this.myTableColumns.size()) {
            theColumnWidth = this.myTableColumns.get(parColumn).length();
        }
        for (int i = 0; i < this.myTableRows.size(); ++i) {
            List<String> theRow = this.myTableRows.get(i);
            if (parColumn < 0 || parColumn >= theRow.size()) continue;
            theColumnWidth = Math.max(theColumnWidth, theRow.get(parColumn).length());
        }
        return theColumnWidth + 2;
    }

    @Override
    protected void newline(PrintWriter parWriter) {
        parWriter.println();
    }

    @Override
    protected void beginTrace(PrintWriter parWriter) {
    }

    @Override
    protected void endTrace(PrintWriter parWriter) {
    }

    @Override
    protected void beginHeader(int parLevel, PrintWriter parWriter) {
        parWriter.println();
        switch (parLevel) {
            case 3: {
                parWriter.print("-[ ");
                break;
            }
            case 2: {
                parWriter.print("--[ ");
                break;
            }
            case 1: {
                parWriter.print("---[ ");
            }
        }
    }

    @Override
    protected void endHeader(int parLevel, PrintWriter parWriter) {
        switch (parLevel) {
            case 3: {
                parWriter.print(" ]---");
                break;
            }
            case 2: {
                parWriter.print(" ]--");
                break;
            }
            case 1: {
                parWriter.print(" ]-");
            }
        }
        parWriter.write(myHorizontalLine, 0, Math.max(0, myHorizontalLine.length() - this.myHeaderLength));
        this.myHeaderLength = 0;
        parWriter.println();
    }

    @Override
    protected void beginHighlight(PrintWriter parWriter) {
    }

    @Override
    protected void endHighlight(PrintWriter parWriter) {
    }

    @Override
    protected void horizontalRuler(PrintWriter parWriter) {
        parWriter.print(myHorizontalLine);
        parWriter.write(myHorizontalLine, 0, 8);
    }

    @Override
    protected void space(PrintWriter parWriter) {
        this.print(" ", parWriter);
    }
}

