/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.executor.TreeExecutorDelegate;
import com.ericsson.ere.selectiontree.conditions.ConditionTestResult;
import com.ericsson.ere.selectiontree.conditions.DefaultConditionTestResult;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.interfaces.ResultConditionality;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.selectiontree.statements.LeafStatement;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.Traceable;
import ericsson.ere.interfaces.TariffStructureNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class TraceTreeExecutor
extends TreeExecutorDelegate {
    private Stack<Level> myLevels = new Stack();
    protected List<TracePoint> myTracePoints = new ArrayList<TracePoint>();
    private AbstractTreeElementTracer<TariffStructure> myTariffStructureTracer;
    private AbstractTreeElementTracer<ExecutableNode> myExecutableNodeTracer;
    private AbstractTreeElementTracer<Conditionality> myConditionalityTracer;
    private AbstractTreeElementTracer<ResultConditionality> myResultConditionalityTracer;
    private AbstractTreeElementTracer<Performable> myPerformableTracer;

    public TraceTreeExecutor() {
        this(new DefaultTreeExecutor());
    }

    public TraceTreeExecutor(TreeExecutor delegee) {
        super(delegee);
        this.myLevels.push(new Level(null));
        this.myTariffStructureTracer = new TariffStructureTracer();
        this.myExecutableNodeTracer = new ExecutableNodeTracer();
        this.myConditionalityTracer = new ConditionalityTracer();
        this.myResultConditionalityTracer = new ResultConditionalityTracer();
        this.myPerformableTracer = new PerformableTracer();
    }

    @Override
    public void execute(TariffStructure tariffStructure, DataSet dataSet) {
        ((AbstractTreeElementTracer)this.myTariffStructureTracer).traceTreeElement(tariffStructure, dataSet);
    }

    @Override
    public void execute(ExecutableNode executableNode, DataSet dataSet) {
        TariffStructureNode actualExecutable = this.extractActualTarget((TariffStructureNode)((Object)executableNode));
        ((AbstractTreeElementTracer)this.myExecutableNodeTracer).traceTreeElement((ExecutableNode)((Object)actualExecutable), dataSet);
    }

    @Override
    public boolean testCondition(Conditionality aCondition, DataSet dataSet) {
        Conditionality actualCondition = (Conditionality)((Object)this.extractActualTarget((TariffStructureNode)((Object)aCondition)));
        TracePoint tp = ((AbstractTreeElementTracer)this.myConditionalityTracer).traceTreeElement(actualCondition, dataSet);
        return TraceHelper.getConditionResult(tp);
    }

    @Override
    public ConditionTestResult testCondition(ResultConditionality aCondition, DataSet dataSet) {
        boolean isLink;
        ConditionTestResult result = null;
        Conditionality actualCondition = (Conditionality)((Object)this.extractActualTarget((TariffStructureNode)((Object)aCondition)));
        boolean bl = isLink = aCondition != actualCondition;
        if (isLink && !(actualCondition instanceof ResultConditionality)) {
            TracePoint tp = ((AbstractTreeElementTracer)this.myConditionalityTracer).traceTreeElement(actualCondition, dataSet);
            result = new DefaultConditionTestResult(TraceHelper.getConditionResult(tp));
        } else {
            TracePoint tp = ((AbstractTreeElementTracer)this.myResultConditionalityTracer).traceTreeElement((ResultConditionality)actualCondition, dataSet);
            result = TraceHelper.getConditionResultObject(tp);
        }
        return result;
    }

    @Override
    public void execute(Performable aPerformable, DataSet aDataSet) {
        Performable actualPerformable = (Performable)((Object)this.extractActualTarget((TariffStructureNode)((Object)aPerformable)));
        this.executeModifier(actualPerformable, aDataSet);
    }

    private void executeModifier(Performable aPerformable, DataSet dataSet) {
        ((AbstractTreeElementTracer)this.myPerformableTracer).traceTreeElement(aPerformable, dataSet);
    }

    private void addLevelInfo(TracePoint aTracePoint, int level, int index) {
        aTracePoint.addInfo(TraceInfoHelper.LEVEL, level);
        aTracePoint.addInfo(TraceInfoHelper.INDEX, index);
    }

    TariffStructureNode extractActualTarget(TariffStructureNode aNode) {
        TariffStructureNode currentNode = aNode;
        while (currentNode.isLink() || currentNode instanceof LeafStatement) {
            currentNode = (TariffStructureNode)currentNode.getChildAt(0);
        }
        return currentNode;
    }

    private int allocateTracePointIndex() {
        int nextIndex = this.myTracePoints.size();
        this.myTracePoints.add(null);
        return nextIndex;
    }

    protected void setTracePoint(TracePoint aTracePoint, int anIndex) {
        this.myTracePoints.set(anIndex, aTracePoint);
    }

    void addAdditionalInfo(TracePoint tp) {
    }

    public TraceData getTraceData() {
        return new TraceData();
    }

    private class PerformableTracer
    extends AbstractTreeElementTracer<Performable> {
        private PerformableTracer() {
        }

        @Override
        protected TracePoint traceSpecificTreeElement(Performable treeElement, DataSet dataSet, TreeExecutor executor) {
            return TraceHelper.traceModifier(treeElement, dataSet, false, executor);
        }

        @Override
        protected void addTreeElementToTracePoint(Performable treeElement, TracePoint tp) {
            TraceInfoHelper.addPerformableToTracePoint(treeElement, tp);
        }
    }

    private class ResultConditionalityTracer
    extends AbstractTreeElementTracer<ResultConditionality> {
        private ResultConditionalityTracer() {
        }

        @Override
        protected TracePoint traceSpecificTreeElement(ResultConditionality treeElement, DataSet dataSet, TreeExecutor executor) {
            return TraceHelper.traceCondition(treeElement, dataSet, executor);
        }

        @Override
        protected void addTreeElementToTracePoint(ResultConditionality treeElement, TracePoint tp) {
            TraceInfoHelper.addConditionalityToTracePoint(treeElement, tp);
        }
    }

    private class ConditionalityTracer
    extends AbstractTreeElementTracer<Conditionality> {
        private ConditionalityTracer() {
        }

        @Override
        protected TracePoint traceSpecificTreeElement(Conditionality treeElement, DataSet dataSet, TreeExecutor executor) {
            return TraceHelper.traceCondition(treeElement, dataSet, executor);
        }

        @Override
        protected void addTreeElementToTracePoint(Conditionality treeElement, TracePoint tp) {
            TraceInfoHelper.addConditionalityToTracePoint(treeElement, tp);
        }
    }

    private class ExecutableNodeTracer
    extends AbstractTreeElementTracer<ExecutableNode> {
        private ExecutableNodeTracer() {
        }

        @Override
        protected TracePoint traceSpecificTreeElement(ExecutableNode treeElement, DataSet dataSet, TreeExecutor executor) {
            return TraceHelper.traceStatement(treeElement, dataSet, false, executor);
        }

        @Override
        protected void addTreeElementToTracePoint(ExecutableNode treeElement, TracePoint tp) {
            TraceInfoHelper.addExecutableNodeToTracePoint(treeElement, tp);
        }
    }

    private class TariffStructureTracer
    extends AbstractTreeElementTracer<TariffStructure> {
        private TariffStructureTracer() {
        }

        @Override
        protected TracePoint traceSpecificTreeElement(TariffStructure treeElement, DataSet dataSet, TreeExecutor executor) {
            return TraceHelper.traceTariffStructure(treeElement, dataSet, executor);
        }

        @Override
        protected void addTreeElementToTracePoint(TariffStructure treeElement, TracePoint tp) {
            TraceInfoHelper.addTariffStructureToTracePoint(treeElement, tp);
        }
    }

    private abstract class AbstractTreeElementTracer<T extends Traceable> {
        private AbstractTreeElementTracer() {
        }

        private TracePoint traceTreeElement(T treeElement, DataSet dataSet) {
            Level current = (Level)TraceTreeExecutor.this.myLevels.peek();
            TraceTreeExecutor.this.myLevels.push(new Level(current));
            int tpIndex = TraceTreeExecutor.this.allocateTracePointIndex();
            int childIndex = current.getSequenceNumber(treeElement);
            TracePoint tp = this.traceSpecificTreeElement(treeElement, dataSet, TraceTreeExecutor.this.getTreeExecutorDelegee());
            TraceTreeExecutor.this.addLevelInfo(tp, current.myLevel, childIndex);
            this.addTreeElementToTracePoint(treeElement, tp);
            TraceTreeExecutor.this.setTracePoint(tp, tpIndex);
            TraceTreeExecutor.this.myLevels.pop();
            TraceTreeExecutor.this.addAdditionalInfo(tp);
            Throwable throwable = TraceHelper.getThrowable(tp);
            TraceHelper.throwOnError(throwable);
            return tp;
        }

        protected abstract TracePoint traceSpecificTreeElement(T var1, DataSet var2, TreeExecutor var3);

        protected abstract void addTreeElementToTracePoint(T var1, TracePoint var2);
    }

    public class TraceData {
        protected TraceData() {
        }

        public List<TracePoint> getTracePoints() {
            return Collections.unmodifiableList(TraceTreeExecutor.this.myTracePoints);
        }

        public String getTraceAsString(DataSet preDataSet, DataSet postDataSet) {
            StringWriter buf = new StringWriter();
            PrintWriter writer = new PrintWriter(buf);
            preDataSet.printTraceHead(writer);
            writer.println();
            for (TracePoint tp : TraceTreeExecutor.this.myTracePoints) {
                if (TraceInfoHelper.traceGenerationIsSuppressed(tp)) continue;
                writer.println(TraceInfoHelper.createTraceStringForTracePoint(tp));
            }
            writer.println();
            postDataSet.printTraceTail(writer, preDataSet);
            writer.flush();
            return buf.toString();
        }
    }

    private static class Level {
        int myLevel;
        int myConditionCounter;
        int myChildCounter;

        Level(Level aCurrentLevel) {
            this.myLevel = aCurrentLevel != null ? aCurrentLevel.myLevel + 1 : 0;
            this.myConditionCounter = 1;
            this.myChildCounter = 1;
        }

        int getSequenceNumber(Object aChild) {
            int num = aChild instanceof Conditionality ? this.myConditionCounter++ : this.myChildCounter++;
            return num;
        }
    }
}

