/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueForKeyNotFoundException;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.Key;

@Immutable
class TracePointDataKey {
    private final Object myIdentifier;
    private final Key myKey;
    private final int myTag;
    private final boolean myPre;

    private TracePointDataKey(Object name, Key key, boolean pre) {
        this.myIdentifier = name;
        this.myKey = key;
        this.myTag = -1;
        this.myPre = pre;
    }

    private TracePointDataKey(int tag, Key key, boolean pre) {
        this.myIdentifier = null;
        this.myTag = tag;
        this.myKey = key;
        this.myPre = pre;
    }

    DataSetValueNotFoundException createDataNotFoundException() {
        DataSetValueNotFoundException exception = this.myKey != null ? (this.myIdentifier != null ? new DataSetValueForKeyNotFoundException(this.myIdentifier.toString(), this.myKey) : new DataSetValueForKeyNotFoundException(this.myTag, this.myKey)) : (this.myIdentifier != null ? new DataSetValueNotFoundException(this.myIdentifier.toString()) : new DataSetValueNotFoundException(this.myTag));
        return exception;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
        result = 31 * result + (this.myIdentifier == null ? 0 : this.myIdentifier.hashCode());
        result = 31 * result + (this.myPre ? 1231 : 1237);
        result = 31 * result + this.myTag;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TracePointDataKey other = (TracePointDataKey)obj;
        if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
            return false;
        }
        if (this.myIdentifier == null ? other.myIdentifier != null : !this.myIdentifier.equals(other.myIdentifier)) {
            return false;
        }
        if (this.myPre != other.myPre) {
            return false;
        }
        return this.myTag == other.myTag;
    }

    static TracePointDataKeyBuilder createKey() {
        return new TracePointDataKeyBuilder();
    }

    static class TracePointDataKeyBuilder {
        private Object myId;
        private Key myKey;
        private int myTag = -1;

        TracePointDataKeyBuilder() {
        }

        TracePointDataKeyBuilder withIdentifier(Object identifier) {
            this.myId = identifier;
            return this;
        }

        TracePointDataKeyBuilder withTag(int tag) {
            this.myTag = tag;
            return this;
        }

        TracePointDataKeyBuilder withDataSetField(DataSetField field) {
            if (field.usesTag()) {
                this.myTag = field.getTag();
            } else {
                this.myId = field.getFieldName();
            }
            return this;
        }

        TracePointDataKeyBuilder andKey(Key key) {
            this.myKey = key;
            return this;
        }

        TracePointDataKey forPreData() {
            return this.createKey(true);
        }

        TracePointDataKey forPostData() {
            return this.createKey(false);
        }

        TracePointDataKey forData(boolean isPreData) {
            return this.createKey(isPreData);
        }

        private TracePointDataKey createKey(boolean isPreData) {
            TracePointDataKey tpdk;
            if (this.myTag > -1) {
                tpdk = new TracePointDataKey(this.myTag, this.myKey, isPreData);
            } else if (this.myId != null) {
                tpdk = new TracePointDataKey(this.myId, this.myKey, isPreData);
            } else {
                throw new IllegalStateException("Builder does not have enough data to create TracePointDataKey");
            }
            return tpdk;
        }
    }
}

