/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Modifier;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeInterfaceV2;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TraceNodeStatement
extends AbstractNodeStatement
implements TraceNodeInterfaceV2 {
    private TraceNodeInterface myTraceNodeParent;
    private final ExecutableNode myStatement;
    private List<TracePoint> myTracePoints = new LinkedList<TracePoint>();
    private ArrayList<TraceNodeInterface> myChildNodes;
    private boolean isExecuted = false;
    private Throwable myException = null;
    private int myLevel;
    private int mySequenceNo = 0;
    private boolean hasCheckedForModifer = false;
    private boolean hasModifierBeenExecuted = false;

    public TraceNodeStatement(ExecutableNode s) {
        this.myStatement = s;
    }

    @Override
    public void addChild(TraceNodeInterface child) {
        if (this.myChildNodes == null) {
            this.myChildNodes = new ArrayList();
        }
        this.myChildNodes.add(child);
    }

    @Override
    public List<TraceNodeInterface> getChildren() {
        return this.myChildNodes;
    }

    @Override
    public void setExecuted() {
        this.isExecuted = true;
    }

    @Override
    public boolean getExecuted() {
        return this.isExecuted;
    }

    @Override
    public Throwable getException() {
        return this.myException;
    }

    @Override
    public void add(XMLInitializable child) {
        if (child instanceof Conditionality || child instanceof Modifier || child instanceof Statement) {
            if (this.myStatement instanceof Statement) {
                ((Statement)this.myStatement).add(child);
            }
        } else {
            throw new IllegalArgumentException("Unknown child class: " + child.getClass());
        }
        this.addChild((TraceNodeInterface)child);
    }

    @Override
    public void execute(DataSet dataSet) {
        TraceHelper.executeTraceTreeElement(this, dataSet);
    }

    @Override
    public String getAllTraceInfo() {
        return "<html><body>" + XMLUtil.escape(this.getTraceInfo(0)) + "</body></html>";
    }

    @Override
    public String getTraceInfo(int seqNo) {
        String traceString = null;
        TracePoint tp = this.myTracePoints.get(seqNo);
        if (!TraceInfoHelper.traceGenerationIsSuppressed(tp)) {
            traceString = TraceInfoHelper.createNodeStatementTraceString(this.myStatement, tp, this.myLevel);
        }
        return traceString;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return null;
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void buildFinished() {
        if (this.myStatement instanceof AbstractNodeStatement) {
            ((AbstractNodeStatement)this.myStatement).buildFinished();
        }
    }

    @Override
    public String toString() {
        if (!this.myStatement.getName().equals(this.myStatement.getNodeId())) {
            return XMLUtil.escape(this.myStatement.getName()) + " [" + XMLUtil.escape(this.myStatement.getNodeId()) + "]";
        }
        return XMLUtil.escape(this.myStatement.getName());
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    public void setParent(TraceNodeInterface parent) {
        this.myTraceNodeParent = parent;
        this.myLevel = this.myTraceNodeParent.getLevel() + 1;
    }

    @Override
    public void setChildIndex(int index) {
    }

    @Override
    public boolean hasRunModifier() {
        if (!this.hasCheckedForModifer) {
            this.hasCheckedForModifer = true;
            for (int i = 0; this.myChildNodes != null && i < this.myChildNodes.size(); ++i) {
                if (!this.myChildNodes.get(i).hasRunModifier()) continue;
                this.hasModifierBeenExecuted = true;
                return true;
            }
        }
        return this.hasModifierBeenExecuted;
    }

    @Override
    public int getNextSeqNo() {
        return this.mySequenceNo++;
    }

    @Override
    public void rebuildLevels() {
        if (this.myTraceNodeParent != null) {
            this.myLevel = this.myTraceNodeParent.getLevel() + 1;
            if (this.myChildNodes != null) {
                for (int i = 0; i < this.myChildNodes.size(); ++i) {
                    this.myChildNodes.get(i).rebuildLevels();
                }
            }
        }
    }

    @Override
    public int getNumberOfTracePoints() {
        return this.myTracePoints.size();
    }

    @Override
    public String describeTracePoint(int index) {
        return this.myStatement.getName();
    }

    @Override
    public void insertChildAt(int index, DAGNode node) {
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) {
    }

    @Override
    public String getNodeLabel() {
        if (!this.myStatement.getName().equals(this.myStatement.getNodeId())) {
            return HTMLUtil.escape(this.myStatement.getName()) + " [" + HTMLUtil.escape(this.myStatement.getNodeId()) + "]";
        }
        return HTMLUtil.escape(this.myStatement.getName());
    }

    @Override
    public TracePoint traceTreeElement(DataSet dataSet) {
        return TraceHelper.traceStatement(this.myStatement, dataSet, true);
    }

    @Override
    public void addTracePoint(TracePoint tp) {
        this.myTracePoints.add(tp);
    }

    @Override
    public void setException(Throwable t) {
        this.myException = t;
    }
}

