/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.interfaces.Modifier;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifier;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeInterfaceV2;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.interfaces.XMLInitializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;

public class TraceNodeModifier
extends AbstractModifier
implements TraceNodeInterfaceV2 {
    private String myTypeName = "TypeNameNotSet";
    private TraceNodeInterface myTraceNodeParent;
    private List<TracePoint> myTracePoints = new LinkedList<TracePoint>();
    private final Performable myModifier;
    private boolean isExecuted = false;
    private Throwable myException = null;
    private ArrayList<TraceNodeInterface> myChildNodes;
    private int mySequenceNo = 0;
    private int myLevel;
    private int myChildIndex;

    public TraceNodeModifier(Performable m) {
        this.myModifier = m;
    }

    @Override
    public void add(XMLInitializable child) {
        if (!(this.myModifier instanceof Modifier)) {
            throw new IllegalArgumentException("Not allowed to add child to " + this.myModifier);
        }
        ((Modifier)this.myModifier).add((Modifier)child);
        this.addChild((TraceNodeInterface)child);
    }

    @Override
    public void add(Modifier child) {
    }

    @Override
    public void setExecuted() {
        this.isExecuted = true;
    }

    @Override
    public boolean getExecuted() {
        return this.isExecuted;
    }

    @Override
    public String getTypename() {
        return this.myTypeName;
    }

    @Override
    public void perform(DataSet dataSet) {
        TraceHelper.executeTraceTreeElement(this, dataSet);
    }

    @Override
    public void addTracePoint(TracePoint tp) {
        this.myTracePoints.add(tp);
    }

    @Override
    public void setTypename(String typename) {
        this.myTypeName = typename;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        return null;
    }

    @Override
    public String getAllTraceInfo() {
        return TraceInfoHelper.getAllTraceInfo(this, new TraceInfoHelper.TracePointProvider(){

            @Override
            public TracePoint getTracePoint(int index) {
                return (TracePoint)TraceNodeModifier.this.myTracePoints.get(index);
            }
        });
    }

    @Override
    public String getTraceInfo(int seqNo) {
        String traceString = null;
        TracePoint tracePoint = this.myTracePoints.get(seqNo);
        if (!TraceInfoHelper.traceGenerationIsSuppressed(tracePoint)) {
            traceString = TraceInfoHelper.createModifierTraceString(this.myModifier, tracePoint, this.myLevel, this.myChildIndex);
        }
        return traceString;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return null;
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void addChild(TraceNodeInterface child) {
        if (this.myChildNodes == null) {
            this.myChildNodes = new ArrayList();
        }
        this.myChildNodes.add(child);
    }

    @Override
    public List<TraceNodeInterface> getChildren() {
        return this.myChildNodes;
    }

    @Override
    public Throwable getException() {
        return this.myException;
    }

    @Override
    public String toString() {
        return this.myModifier.toString();
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    public void setParent(TraceNodeInterface parent) {
        this.myTraceNodeParent = parent;
        this.myLevel = this.myTraceNodeParent.getLevel() + 1;
    }

    @Override
    public void setChildIndex(int index) {
        this.myChildIndex = index + 1;
    }

    @Override
    public boolean hasRunModifier() {
        return this.isExecuted;
    }

    @Override
    public int getNextSeqNo() {
        return this.mySequenceNo++;
    }

    @Override
    public void rebuildLevels() {
        if (this.myTraceNodeParent != null) {
            this.myLevel = this.myTraceNodeParent.getLevel() + 1;
            if (this.myChildNodes != null) {
                for (int i = 0; i < this.myChildNodes.size(); ++i) {
                    this.myChildNodes.get(i).rebuildLevels();
                }
            }
        }
    }

    @Override
    public int getNumberOfTracePoints() {
        return this.myTracePoints.size();
    }

    @Override
    public String describeTracePoint(int index) {
        String traceString = "";
        if (index >= 0 && index < this.getNumberOfTracePoints()) {
            traceString = this.getModifierTraceDescription(this.myTracePoints.get(index));
        }
        return traceString;
    }

    private String getModifierTraceDescription(TracePoint tp) {
        return TraceInfoHelper.createModifierTraceString(this.myModifier, tp);
    }

    @Override
    public String getNodeLabel() {
        String nodeId = "";
        String modifierTypeName = "";
        if (this.myModifier instanceof ImmutableModifier) {
            nodeId = ((ImmutableModifier)this.myModifier).getNodeId();
            modifierTypeName = ((ImmutableModifier)this.myModifier).getName();
        } else if (this.myModifier instanceof AbstractModifier) {
            nodeId = ((AbstractModifier)this.myModifier).getNodeId();
            modifierTypeName = ((AbstractModifier)this.myModifier).getTypename();
        }
        nodeId = nodeId != "" && !nodeId.equals(modifierTypeName) ? " [" + HTMLUtil.escape(nodeId) + "]" : "";
        return this.myModifier.toString() + nodeId;
    }

    @Override
    public TracePoint traceTreeElement(DataSet dataSet) {
        return TraceHelper.traceModifier(this.myModifier, dataSet, true);
    }

    @Override
    public void setException(Throwable t) {
        this.myException = t;
    }
}

