/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.conditions.AbstractCondition;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeInterfaceV2;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TraceNodeCondition
extends AbstractCondition
implements TraceNodeInterfaceV2 {
    private TraceNodeInterface myTraceNodeParent;
    private List<TracePoint> myTracePoints = new LinkedList<TracePoint>();
    private Conditionality myCondition;
    private ArrayList<TraceNodeInterface> myChildNodes;
    private int myLevel;
    private int myChildIndex;
    private int mySequenceNo = 0;
    private boolean isExecuted = false;
    private Throwable myException = null;

    public TraceNodeCondition(Conditionality c) {
        if (!(c instanceof TariffStructureNode)) {
            throw new IllegalArgumentException("TraceNodeCondition needs TariffStructureNode argument");
        }
        this.myCondition = c;
    }

    @Override
    public void add(XMLInitializable child) {
        ((TariffStructureNode)((Object)this.myCondition)).addChild((DAGNode)((Object)child));
        this.addChild((TraceNodeInterface)child);
    }

    @Override
    public void setExecuted() {
        this.isExecuted = true;
    }

    @Override
    public boolean getExecuted() {
        return this.isExecuted;
    }

    @Override
    public boolean test(DataSet dataSet) {
        TracePoint tp = TraceHelper.executeTraceTreeElement(this, dataSet);
        return TraceHelper.getConditionResult(tp);
    }

    @Override
    public void addTracePoint(TracePoint tp) {
        this.myTracePoints.add(tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return null;
    }

    @Override
    public String getAllTraceInfo() {
        return TraceInfoHelper.getAllTraceInfo(this, new TraceInfoHelper.TracePointProvider(){

            @Override
            public TracePoint getTracePoint(int index) {
                return (TracePoint)TraceNodeCondition.this.myTracePoints.get(index);
            }
        });
    }

    @Override
    public String getTraceInfo(int seqNo) {
        String traceString = null;
        TracePoint tp = this.myTracePoints.get(seqNo);
        if (!TraceInfoHelper.traceGenerationIsSuppressed(tp)) {
            traceString = TraceInfoHelper.createConditionTraceString(this.myCondition, tp, this.myLevel, this.myChildIndex);
        }
        return traceString;
    }

    @Override
    public void addChild(TraceNodeInterface child) {
        if (this.myChildNodes == null) {
            this.myChildNodes = new ArrayList();
        }
        this.myChildNodes.add(child);
    }

    @Override
    public List<TraceNodeInterface> getChildren() {
        return this.myChildNodes;
    }

    @Override
    public Throwable getException() {
        return this.myException;
    }

    @Override
    public String toString() {
        boolean testResult = false;
        for (TracePoint tp : this.myTracePoints) {
            if (!((Boolean)tp.getInfo(TEST_RESULT)).booleanValue()) continue;
            testResult = true;
            break;
        }
        return this.myCondition.toString() + (this.isExecuted ? " (<b>" + testResult + "</b>)" : "");
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    public void setParent(TraceNodeInterface parent) {
        this.myTraceNodeParent = parent;
        this.myLevel = this.myTraceNodeParent.getLevel() + 1;
    }

    @Override
    public void setChildIndex(int index) {
        this.myChildIndex = index + 1;
    }

    @Override
    public boolean hasRunModifier() {
        return false;
    }

    @Override
    public int getNextSeqNo() {
        return this.mySequenceNo++;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return this.myCondition.getConditionSatisfiedDuration(theData);
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return this.myCondition.getConditionUnsatisfiedDuration(theData);
    }

    @Override
    public void rebuildLevels() {
        if (this.myTraceNodeParent != null) {
            this.myLevel = this.myTraceNodeParent.getLevel() + 1;
            if (this.myChildNodes != null) {
                for (int i = 0; i < this.myChildNodes.size(); ++i) {
                    this.myChildNodes.get(i).rebuildLevels();
                }
            }
        }
    }

    @Override
    public int getNumberOfTracePoints() {
        return this.myTracePoints.size();
    }

    @Override
    public String describeTracePoint(int index) {
        StringBuilder trace = new StringBuilder();
        if (index >= 0 && index < this.getNumberOfTracePoints()) {
            TracePoint tp = this.myTracePoints.get(index);
            boolean testResult = (Boolean)tp.getInfo(TEST_RESULT);
            trace.append("(").append(testResult).append(") ").append(HTMLUtil.escape(this.getConditionTraceDescription(tp)));
        }
        return trace.toString();
    }

    @Override
    public void enter(DataSet data) {
        this.myCondition.enter(data);
    }

    @Override
    public boolean isReadyToLeave(DataSet data) {
        return this.myCondition.isReadyToLeave(data);
    }

    @Override
    public void leave(DataSet data) {
        this.myCondition.leave(data);
    }

    private String getConditionTraceDescription(TracePoint tp) {
        return TraceInfoHelper.getTraceDescription(this.myCondition, ((TariffStructureNode)((Object)this.myCondition)).getNodeId(), tp);
    }

    @Override
    public String getNodeLabel() {
        boolean testResult = false;
        for (TracePoint tp : this.myTracePoints) {
            if (!((Boolean)tp.getInfo(TEST_RESULT)).booleanValue()) continue;
            testResult = true;
            break;
        }
        String nodeId = "";
        String conditionTypeName = "";
        if (this.myCondition instanceof ImmutableCondition) {
            nodeId = ((ImmutableCondition)this.myCondition).getNodeId();
            conditionTypeName = ((ImmutableCondition)this.myCondition).getTypename();
        } else if (this.myCondition instanceof AbstractCondition) {
            nodeId = ((AbstractCondition)this.myCondition).getNodeId();
            conditionTypeName = ((AbstractCondition)this.myCondition).getTypename();
        }
        nodeId = nodeId != "" && !nodeId.equals(conditionTypeName) ? " [" + HTMLUtil.escape(nodeId) + "]" : "";
        return this.myCondition.toString() + (this.isExecuted ? " (<b>" + testResult + "</b>)" : "") + nodeId;
    }

    @Override
    public TracePoint traceTreeElement(DataSet dataSet) {
        return TraceHelper.traceCondition(this.myCondition, dataSet);
    }

    @Override
    public void setException(Throwable t) {
        this.myException = t;
    }
}

