/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetAccessor;
import com.ericsson.ere.dataset.DataSetArrayHelper;
import com.ericsson.ere.dataset.IncompatibleDataSetValueException;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.ValueContainer;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.structures.PeriodTreeDescription;
import com.ericsson.ere.trace.TraceHelper;
import com.ericsson.ere.trace.TraceNodeTariffStructure;
import com.ericsson.ere.trace.TraceOrderHandler;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TracePointDataKey;
import com.ericsson.ere.trace.TraceTreeInfo;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TraceDataSet
implements DataSet {
    private static final long MILLI_SEC_IN_ONE_DAY = 86400000L;
    static final TracePointDataKey PRE_CURRENT_TIME = TracePointDataKey.createKey().withIdentifier(new Object()).forPreData();
    static final TracePointDataKey POST_CURRENT_TIME = TracePointDataKey.createKey().withIdentifier(new Object()).forPostData();
    private TracePoint myTracePoint;
    private DataSet myOriginalDataSet;
    private boolean myIsPreDataSet;
    private DataSetAccessor myAccessor;

    public static TraceDataSet createPreDataSet(TracePoint tp) {
        return new TraceDataSet(tp, true);
    }

    public static TraceDataSet createPostDataSet(TracePoint tp) {
        return new TraceDataSet(tp, false);
    }

    protected TraceDataSet(TracePoint tp, boolean isPreDataSet) {
        if (tp == null) {
            throw new IllegalArgumentException("Trace point parameter must not be null.");
        }
        DataSet dataSet = this.myOriginalDataSet = isPreDataSet ? tp.getPreDataSet() : tp.getPostDataSet();
        if (this.myOriginalDataSet == null) {
            throw new IllegalArgumentException("Trace point must contain data set.");
        }
        this.myTracePoint = tp;
        this.myIsPreDataSet = isPreDataSet;
    }

    @Override
    public DataSetAccessor getAccessor() {
        if (this.myAccessor == null) {
            this.myAccessor = new TraceDataSetAccessor();
        }
        return this.myAccessor;
    }

    @Override
    public Object getDataAsTypedObjectForKey(int tag, Key key, DataType desiredDataType) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withTag(tag).andKey(key).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, true);
    }

    private Object getValueFromTracePoint(TracePointDataKey tpk, boolean throwOnNull) {
        Object value = this.myTracePoint.getInfo(tpk);
        if (value == null && throwOnNull) {
            throw tpk.createDataNotFoundException();
        }
        return value;
    }

    @Override
    public Object getDataAsTypedObjectForKey(Object name, Key key, DataType desiredDataType) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withIdentifier(name).andKey(key).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, true);
    }

    @Override
    public Map<?, ?> getDataAsMap(int tag, DataType valueDataType) {
        Object dataObject = this.getDataAsObject(tag);
        return this.handleGetAsMap(tag, dataObject);
    }

    @Override
    public Map<?, ?> getDataAsMap(Object name, DataType valueDataType) {
        Object dataObject = this.getDataAsObject(name);
        return this.handleGetAsMap(name, dataObject);
    }

    private Map<?, ?> handleGetAsMap(Object key, Object dataObject) {
        if (dataObject instanceof Map) {
            return (Map)dataObject;
        }
        if (DataSetArrayHelper.isOneDimensionalArray(dataObject)) {
            return DataSetArrayHelper.convertArrayToMap(dataObject);
        }
        return Collections.singletonMap(key, dataObject);
    }

    @Override
    public void setDataAsObjectForKey(int tag, Key key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsObjectForKey(Object name, Key key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasDataForKey(Object name, Key key) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withIdentifier(name).andKey(key).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, false) != null;
    }

    @Override
    public boolean hasDataForKey(int tag, Key key) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withTag(tag).andKey(key).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, false) != null;
    }

    @Override
    public void setDataAsEREDate(Object name, EREDate date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsEREDate(int tag, EREDate date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsERETime(Object name, ERETime date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsERETime(int tag, ERETime date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EREDate getDataAsEREDate(Object name) {
        return EREDateUtil.convertToEREDate(this.getDataAsObject(name));
    }

    @Override
    public EREDate getDataAsEREDate(int tag) {
        return EREDateUtil.convertToEREDate(this.getDataAsObject(tag));
    }

    @Override
    public ERETime getDataAsERETime(Object name) {
        return ERETimeUtil.convertToERETime(this.getDataAsObject(name));
    }

    @Override
    public ERETime getDataAsERETime(int tag) {
        return ERETimeUtil.convertToERETime(this.getDataAsObject(tag));
    }

    @Override
    public Calendar getStartTime() {
        return this.myOriginalDataSet.getStartTime();
    }

    @Override
    public Calendar getCurrentTime() {
        Object infoObject = this.myTracePoint.getInfo(this.myIsPreDataSet ? PRE_CURRENT_TIME : POST_CURRENT_TIME);
        Calendar currentTime = infoObject != null ? (Calendar)((Calendar)infoObject).clone() : (Calendar)this.getStartTime().clone();
        return currentTime;
    }

    @Override
    public void setCurrentTime(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void allocateTime(int second) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Service getService() {
        Service service = TraceHelper.getServiceFromTracePoint(this.myTracePoint, this.myIsPreDataSet);
        if (service == null) {
            service = this.myOriginalDataSet.getService();
        }
        return service;
    }

    @Override
    public void execute(RatingPlan plan, Calendar startTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeWithTrace(TraceNodeTariffStructure tariff) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TraceTreeInfo executeWithTrace(RatingPlan plan, Calendar startTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reExecute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopExecution() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean shallExecutionStop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifierExecuted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasModifierBeenExecuted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getModifierExecutionCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTreeTask(TreeTask task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeTask getTreeTask() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTraceOrderHandler(TraceOrderHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TraceOrderHandler getTraceOrderHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String diffDataSet(DataSet newSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printTraceHead(PrintWriter writer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printTraceTail(PrintWriter writer, DataSet originalDataSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasData(Object name) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withIdentifier(name).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, false) != null;
    }

    @Override
    public boolean hasData(int tag) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withTag(tag).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, false) != null;
    }

    @Override
    public Object getDataAsObject(int tag) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withTag(tag).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, true);
    }

    @Override
    public Object getDataAsObject(Object name) {
        TracePointDataKey tpk = TracePointDataKey.createKey().withIdentifier(name).forData(this.myIsPreDataSet);
        return this.getValueFromTracePoint(tpk, true);
    }

    @Override
    public void setDataAsObject(int tag, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsObject(Object name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getDataAsByte(int tag) {
        return (Byte)this.getDataAsObject(tag);
    }

    @Override
    public byte getDataAsByte(Object name) {
        return (Byte)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsByte(int tag, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsByte(Object name, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getDataAsShort(int tag) {
        return (Short)this.getDataAsObject(tag);
    }

    @Override
    public short getDataAsShort(Object name) {
        return (Short)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsShort(int tag, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsShort(Object name, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDataAsInt(int tag) {
        return (Integer)this.getDataAsObject(tag);
    }

    @Override
    public int getDataAsInt(Object name) {
        return (Integer)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsInt(int tag, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsInt(Object name, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDataAsLong(int tag) {
        return (Long)this.getDataAsObject(tag);
    }

    @Override
    public long getDataAsLong(Object name) {
        return (Long)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsLong(int tag, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsLong(Object name, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDataAsDouble(int tag) {
        return (Double)this.getDataAsObject(tag);
    }

    @Override
    public double getDataAsDouble(Object name) {
        return (Double)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsDouble(int tag, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsDouble(Object name, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RatingDecimal getDataAsRatingDecimal(int tag) {
        return (RatingDecimal)this.getDataAsObject(tag);
    }

    @Override
    public RatingDecimal getDataAsRatingDecimal(Object name) {
        return (RatingDecimal)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsRatingDecimal(int tag, RatingDecimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsRatingDecimal(Object name, RatingDecimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDataAsString(int tag) {
        return (String)this.getDataAsObject(tag);
    }

    @Override
    public String getDataAsString(Object name) {
        return (String)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsString(int tag, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsString(Object name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getDataAsBigDecimal(int tag) {
        return (BigDecimal)this.getDataAsObject(tag);
    }

    @Override
    public BigDecimal getDataAsBigDecimal(Object name) {
        return (BigDecimal)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsBigDecimal(int tag, BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsBigDecimal(Object name, BigDecimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getDataAsBigInteger(int tag) {
        return (BigInteger)this.getDataAsObject(tag);
    }

    @Override
    public BigInteger getDataAsBigInteger(Object name) {
        return (BigInteger)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsBigInteger(int tag, BigInteger value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsBigInteger(Object name, BigInteger value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number getDataAsNumber(int tag) {
        return (Number)this.getDataAsObject(tag);
    }

    @Override
    public Number getDataAsNumber(Object name) {
        return (Number)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsNumber(int tag, Number value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsNumber(Object name, Number value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDataAsBoolean(int tag) {
        return (Boolean)this.getDataAsObject(tag);
    }

    @Override
    public boolean getDataAsBoolean(Object name) {
        return (Boolean)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsBoolean(int tag, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsBoolean(Object name, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putState(Object key, Object state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getState(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeState(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsUnsignedInt32(Object name, UnsignedInt32 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedInt32 getDataAsUnsignedInt32(Object name) {
        return (UnsignedInt32)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsUnsignedInt32(int tag, UnsignedInt32 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedInt32 getDataAsUnsignedInt32(int tag) {
        return (UnsignedInt32)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsUnsignedInt16(Object name, UnsignedInt16 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedInt16 getDataAsUnsignedInt16(Object name) {
        return (UnsignedInt16)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsUnsignedInt16(int tag, UnsignedInt16 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedInt16 getDataAsUnsignedInt16(int tag) {
        return (UnsignedInt16)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsUnsignedInt8(Object name, UnsignedInt8 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedInt8 getDataAsUnsignedInt8(Object name) {
        return (UnsignedInt8)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsUnsignedInt8(int tag, UnsignedInt8 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedInt8 getDataAsUnsignedInt8(int tag) {
        return (UnsignedInt8)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsMonetaryUnits(Object name, MonetaryUnits value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MonetaryUnits getDataAsMonetaryUnits(Object name) {
        return (MonetaryUnits)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsMonetaryUnits(int tag, MonetaryUnits value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MonetaryUnits getDataAsMonetaryUnits(int tag) {
        return (MonetaryUnits)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsAmount(Object name, Amount value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Amount getDataAsAmount(Object name) {
        return (Amount)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsAmount(int tag, Amount value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Amount getDataAsAmount(int tag) {
        return (Amount)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsDecimal(Object name, Decimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decimal getDataAsDecimal(Object name) {
        return (Decimal)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsDecimal(int tag, Decimal value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decimal getDataAsDecimal(int tag) {
        return (Decimal)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsTime(Object name, Time value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getDataAsTime(Object name) {
        return (Time)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsTime(int tag, Time value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getDataAsTime(int tag) {
        return (Time)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsBcdString(Object name, BcdString value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BcdString getDataAsBcdString(Object name) {
        return (BcdString)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsBcdString(int tag, BcdString value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BcdString getDataAsBcdString(int tag) {
        return (BcdString)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsOctetString(Object name, OctetString value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OctetString getDataAsOctetString(Object name) {
        return (OctetString)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsOctetString(int tag, OctetString value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OctetString getDataAsOctetString(int tag) {
        return (OctetString)this.getDataAsObject(tag);
    }

    @Override
    public void setDataAsDate(Object name, Date value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDataAsDate(Object name) {
        return (Date)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsDate(int tag, Date value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDataAsDate(int tag) {
        return (Date)this.getDataAsObject(tag);
    }

    @Override
    public Long getStartTimeAsDaysSinceEpoch() {
        return this.getDaysForDate(this.getStartTime());
    }

    @Override
    public Long getCurrentTimeAsDaysSinceEpoch() {
        return this.getDaysForDate(this.getCurrentTime());
    }

    private long getDaysForDate(Calendar cal) {
        long milliSec = cal.getTimeInMillis() + (long)cal.get(15) + (long)cal.get(16);
        return milliSec / 86400000L;
    }

    @Override
    public Long getDataAsDaysSinceEpoch(int tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getDataAsDaysSinceEpoch(Object name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentServiceProvider() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCurrentServiceProvider(String currentServiceProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentRatingPlanName() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentRatingPlan(String currentRatingPlan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCurrentRatingPeriod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCurrentRatingPeriod(String currentRatingPeriod) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPeriodTreeDescritpion(PeriodTreeDescription periodTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PeriodTreeDescription> getPeriodTreeDescriptionList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AmountFactory getAmountFactory() {
        return this.myOriginalDataSet.getAmountFactory();
    }

    @Override
    public void setTreeExecutor(TreeExecutor executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeExecutor getTreeExecutor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Set<?> getDataAsSet(int tag, DataType dt) {
        Object obj = this.getDataAsObject(tag);
        if (!(obj instanceof Set)) {
            throw new IncompatibleDataSetValueException("Value is not a set: " + obj.getClass());
        }
        return (Set)obj;
    }

    @Override
    public Set<?> getDataAsSet(Object name, DataType dt) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null.");
        }
        Object obj = this.getDataAsObject(name);
        if (!(obj instanceof Set)) {
            throw new IncompatibleDataSetValueException("Value is not a set: " + obj.getClass());
        }
        return (Set)obj;
    }

    @Override
    public void setDataAsSet(int tag, Set<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataAsSet(Object name, Set<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAccessor(DataSetAccessor acc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RatingPlan getCurrentRatingPlan() {
        RatingPlan ratingPlan = TraceHelper.getRatingPlanFromTracePoint(this.myTracePoint, this.myIsPreDataSet);
        if (ratingPlan == null) {
            ratingPlan = this.myOriginalDataSet.getCurrentRatingPlan();
        }
        return ratingPlan;
    }

    @Override
    public void setCurrentRatingPlan(RatingPlan currentRatingPlan) {
        throw new UnsupportedOperationException();
    }

    private class TraceDataSetAccessor
    implements DataSetAccessor {
        private TraceDataSetAccessor() {
        }

        private TracePointDataKey createKeyForField(FieldHierarchyNode field, List<Key> keys) {
            int tag;
            boolean useTag;
            TracePointDataKey.TracePointDataKeyBuilder tpk = TracePointDataKey.createKey();
            if (keys != null && keys.size() > 0) {
                tpk.andKey(keys.get(0));
            }
            boolean bl = useTag = (tag = field.getTagNumber()) > -1;
            if (useTag) {
                tpk.withTag(tag);
            } else {
                tpk.withIdentifier(field.getCanonicalName());
            }
            return tpk.forData(TraceDataSet.this.myIsPreDataSet);
        }

        @Override
        public <T> T getValue(FieldHierarchyNode field, List<Key> keys, DataType type) {
            return (T)TraceDataSet.this.getValueFromTracePoint(this.createKeyForField(field, keys), true);
        }

        @Override
        public <T> void setValue(FieldHierarchyNode field, List<Key> keys, DataType type, T aValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasValue(FieldHierarchyNode field, List<Key> keys) {
            return TraceDataSet.this.getValueFromTracePoint(this.createKeyForField(field, keys), false) != null;
        }

        @Override
        public <T> T removeValue(FieldHierarchyNode field, List<Key> keys, DataType type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueContainer entryOf(FieldStructure parent, Object[] values) {
            throw new UnsupportedOperationException();
        }
    }
}

