/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.text;

import java.util.LinkedList;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public final class ReadOnlyDocument
implements Document,
Element {
    private char[] myData;
    private transient int myLineCount;
    private transient int[] myLinePositions;

    public ReadOnlyDocument(String s) {
        this(s.toCharArray());
    }

    public ReadOnlyDocument(char[] chars) {
        this.init(chars);
    }

    private void init(char[] chars) {
        this.myData = chars;
        this.findStringLines();
    }

    private void findStringLines() {
        int i;
        LinkedList<Integer> positionList = new LinkedList<Integer>();
        positionList.add(new Integer(0));
        for (i = 0; i < this.myData.length; ++i) {
            if (this.myData[i] != '\n') continue;
            positionList.add(new Integer(i + 1));
        }
        this.myLineCount = positionList.size();
        this.myLinePositions = new int[this.myLineCount];
        i = 0;
        for (Integer ii : positionList) {
            this.myLinePositions[i++] = ii;
        }
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException("Bad position", offset);
        }
        return new RODPosition(offset);
    }

    @Override
    public Element getDefaultRootElement() {
        return this;
    }

    @Override
    public Position getEndPosition() {
        return new RODEndPosition();
    }

    @Override
    public int getLength() {
        return this.myData.length;
    }

    @Override
    public Object getProperty(Object key) {
        return null;
    }

    @Override
    public Element[] getRootElements() {
        return new Element[]{this};
    }

    @Override
    public Position getStartPosition() {
        return new RODStartPosition();
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        if (offset < 0 || offset + length > this.myData.length || length < 0) {
            throw new BadLocationException("Bad: " + offset + "," + length, offset);
        }
        if (length == 0) {
            return "";
        }
        return new String(this.myData, offset, length);
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        if (offset < 0 || offset + length > this.myData.length || length < 0) {
            throw new BadLocationException("Bad: " + offset + "," + length, offset);
        }
        txt.array = this.myData;
        txt.offset = offset;
        txt.count = length;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putProperty(Object key, Object value) {
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        throw new UnsupportedOperationException("Read only buffer");
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    @Override
    public void render(Runnable r) {
        r.run();
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public Element getElement(int index) {
        return new RODElement(index);
    }

    @Override
    public int getElementCount() {
        return this.myLineCount;
    }

    @Override
    public int getElementIndex(int offset) {
        return this.lineForPosition(offset);
    }

    @Override
    public int getEndOffset() {
        return this.getLength();
    }

    @Override
    public String getName() {
        return "rod";
    }

    @Override
    public Element getParentElement() {
        return null;
    }

    @Override
    public int getStartOffset() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return this.getElementCount() == 0;
    }

    private int lineForPosition(int offset) {
        int result = -1;
        if (offset <= 0) {
            result = 0;
        } else {
            if (offset >= this.getLength()) {
                return this.myLineCount - 1;
            }
            for (int i = 1; i < this.myLinePositions.length; ++i) {
                if (offset >= this.myLinePositions[i]) continue;
                result = i - 1;
                break;
            }
        }
        if (result < 0) {
            result = offset < 0 ? 0 : this.myLineCount - 1;
        }
        return result;
    }

    private int positionOfLine(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.myLinePositions.length) {
            throw new IllegalArgumentException("Invalid line index.");
        }
        return this.myLinePositions[lineIndex];
    }

    final class RODElement
    implements Element {
        private int lineIndex;

        public RODElement(int lineIndex) {
            this.lineIndex = lineIndex;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public Document getDocument() {
            return ReadOnlyDocument.this;
        }

        @Override
        public Element getElement(int param) {
            return null;
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public int getElementIndex(int param) {
            return -1;
        }

        @Override
        public int getEndOffset() {
            int result = this.lineIndex == ReadOnlyDocument.this.myLineCount - 1 ? ReadOnlyDocument.this.getLength() : ReadOnlyDocument.this.positionOfLine(this.lineIndex + 1);
            return result;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Element getParentElement() {
            return ReadOnlyDocument.this;
        }

        @Override
        public int getStartOffset() {
            return ReadOnlyDocument.this.positionOfLine(this.lineIndex);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    final class RODStartPosition
    extends RODPosition {
        public RODStartPosition() {
            super(0);
        }
    }

    final class RODEndPosition
    extends RODPosition {
        public RODEndPosition() {
            super(ReadOnlyDocument.this.getLength());
        }
    }

    class RODPosition
    implements Position {
        private int offset;

        public RODPosition(int offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }
}

