/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class TreeNodeExpansionState
implements Serializable {
    private static final long serialVersionUID = 191L;
    private final Map<String, List<String>> myState;

    public TreeNodeExpansionState(JTree tree) {
        this.myState = this.getTreeNodeExpansionState(tree);
    }

    public void restore(JTree tree) {
        this.setTreeNodeExpansionState(tree, this.myState, tree.getPathForRow(0));
    }

    private Map<String, List<String>> getTreeNodeExpansionState(JTree tree) {
        HashMap<String, List<String>> toExpand = new HashMap<String, List<String>>();
        for (int i = 1; i < tree.getRowCount(); ++i) {
            if (!tree.isExpanded(i)) continue;
            TreePath path = tree.getPathForRow(i);
            String parentPath = path.getParentPath().toString();
            ArrayList<String> values = (ArrayList<String>)toExpand.get(parentPath);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(path.getLastPathComponent().toString());
            toExpand.put(parentPath, values);
        }
        return toExpand;
    }

    private void setTreeNodeExpansionState(JTree tree, Map<String, List<String>> toExpand, TreePath rootPath) {
        List<String> values = toExpand.remove(rootPath.toString());
        int row = tree.getRowForPath(rootPath);
        if (values != null) {
            int startRow;
            String value;
            TreePath nextMatch;
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext() && (nextMatch = tree.getNextMatch(value = iterator.next(), startRow = Math.min(row + 1, tree.getRowCount() - 1), Position.Bias.Forward)) != null) {
                tree.expandPath(nextMatch);
                if (!toExpand.containsKey(nextMatch.toString())) continue;
                this.setTreeNodeExpansionState(tree, toExpand, nextMatch);
            }
        }
    }
}

