/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import ericsson.ere.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EventSource
implements ListSelectionListener {
    private List<ActionListener> myListeners = new ArrayList<ActionListener>();
    private final String myActionCommand;
    private final int myActionID;

    public EventSource() {
        this(null, 0);
    }

    public EventSource(String actionCommand) {
        this(actionCommand, 0);
    }

    public EventSource(int actionID) {
        this(null, actionID);
    }

    public EventSource(String actionCommand, int actionID) {
        this.myActionCommand = actionCommand;
        this.myActionID = actionID;
    }

    public void addActionListener(ActionListener l) {
        this.myListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.myListeners.remove(l);
    }

    public void fire(ActionEvent e) {
        this.fireEvent(e);
    }

    private void fire(Object source, EventObject cause) {
        NestedActionEvent e = new NestedActionEvent(source, this.myActionID, this.myActionCommand, cause);
        this.fireEvent(e);
    }

    public void fire(Object source) {
        ActionEvent e = new ActionEvent(source, this.myActionID, this.myActionCommand);
        this.fireEvent(e);
    }

    protected void fireEvent(ActionEvent e) {
        for (ActionListener l : this.myListeners) {
            l.actionPerformed(e);
        }
    }

    public JRadioButton createRadioButton(boolean checked) {
        return this.createRadioButton(checked, null);
    }

    public JRadioButton createRadioButton(boolean checked, String tooltip) {
        JRadioButton rb = new JRadioButton();
        rb.setSelected(checked);
        if (!StringUtil.isEmptyString(tooltip)) {
            rb.setToolTipText(tooltip);
        }
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventSource.this.fireEvent(e);
            }
        });
        return rb;
    }

    public JCheckBox createCheckBox(boolean checked) {
        return this.createCheckBox(checked, null);
    }

    public JCheckBox createCheckBox(boolean checked, String tooltip) {
        JCheckBox cb = new JCheckBox();
        cb.setSelected(checked);
        if (!StringUtil.isEmptyString(tooltip)) {
            cb.setToolTipText(tooltip);
        }
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventSource.this.fireEvent(e);
            }
        });
        return cb;
    }

    public JButton createButton(String text) {
        return this.createButton(text, null);
    }

    public JButton createButton(String text, Icon icon) {
        return this.createButton(text, icon, null);
    }

    public JButton createButton(String text, Icon icon, String tooltip) {
        JButton btn = new JButton(text);
        if (!StringUtil.isEmptyString(tooltip)) {
            btn.setToolTipText(tooltip);
        }
        if (icon != null) {
            btn.setIcon(icon);
        }
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventSource.this.fireEvent(e);
            }
        });
        return btn;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.fire(e.getSource(), e);
        }
    }

    public static class NestedActionEvent
    extends ActionEvent {
        private EventObject myParent;

        NestedActionEvent(Object source, int id, String command, EventObject parent) {
            super(source, id, command, System.currentTimeMillis(), 0);
            this.myParent = parent;
        }

        public EventObject getCausingEvent() {
            return this.myParent;
        }
    }
}

