/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public final class EDT {
    private EDT() {
    }

    public static void runLater(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void runAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException ex) {
                throw new UncheckedInterruptedException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getCause();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw (RuntimeException)t;
            }
        }
    }

    public static <T> T runAndWait(Callable<T> callable) throws Exception {
        T retVal;
        if (EventQueue.isDispatchThread()) {
            retVal = callable.call();
        } else {
            try {
                retVal = EDT.callSynchronouslyAsRunnable(callable);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getCause();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw (Exception)t;
            }
        }
        return retVal;
    }

    public static <T> T runAndWait(final ValueRunnable<T> runner) {
        T retVal;
        if (EventQueue.isDispatchThread()) {
            retVal = runner.run();
        } else {
            try {
                retVal = EDT.callSynchronouslyAsRunnable(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return runner.run();
                    }
                });
            }
            catch (InterruptedException ex) {
                throw new UncheckedInterruptedException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getCause();
                assert (t instanceof RuntimeException);
                throw (RuntimeException)t;
            }
        }
        return retVal;
    }

    private static <T> T callSynchronouslyAsRunnable(final Callable<T> c) throws InterruptedException, InvocationTargetException {
        final Object[] arr = new Object[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object result = c.call();
                        arr[0] = result;
                    }
                    catch (Exception e) {
                        throw new UncheckedWrapper(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof UncheckedWrapper) {
                throw new InvocationTargetException(e.getCause().getCause());
            }
            throw e;
        }
        return (T)arr[0];
    }

    public static interface ValueRunnable<T> {
        public T run();
    }

    private static class UncheckedWrapper
    extends RuntimeException {
        public UncheckedWrapper(Throwable t) {
            super(t);
        }
    }
}

