/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    private Icon myBase;
    private Icon myDecoration;
    private int myLocationX;
    private int myLocationY;

    public CompoundIcon(Icon base, Icon decoration, AlignCorner align) {
        this(base, decoration, align.getX(base, decoration), align.getY(base, decoration));
    }

    public CompoundIcon(Icon base, Icon decoration, int locx, int locy) {
        if (base == null) {
            throw new IllegalArgumentException("Base icon cannot be null.");
        }
        this.myBase = base;
        this.myDecoration = decoration;
        this.myLocationX = locx;
        this.myLocationY = locy;
    }

    @Override
    public int getIconHeight() {
        return this.myBase.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.myBase.getIconWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.myDecoration == null) {
            this.myBase.paintIcon(c, g, x, y);
        } else {
            Rectangle oldClip = g.getClipBounds();
            try {
                g.setClip(x, y, this.getIconWidth(), this.getIconHeight());
                this.myBase.paintIcon(c, g, x, y);
                this.myDecoration.paintIcon(c, g, x + this.myLocationX, y + this.myLocationY);
            }
            finally {
                g.setClip(oldClip);
            }
        }
    }

    public static enum AlignCorner {
        TopLeft{

            @Override
            int getX(Icon base, Icon decoration) {
                return 0;
            }

            @Override
            int getY(Icon base, Icon decoration) {
                return 0;
            }
        }
        ,
        TopRight{

            @Override
            int getX(Icon base, Icon decoration) {
                return base.getIconWidth() - decoration.getIconWidth();
            }

            @Override
            int getY(Icon base, Icon decoration) {
                return 0;
            }
        }
        ,
        BottomLeft{

            @Override
            int getX(Icon base, Icon decoration) {
                return 0;
            }

            @Override
            int getY(Icon base, Icon decoration) {
                return base.getIconHeight() - decoration.getIconHeight();
            }
        }
        ,
        BottomRight{

            @Override
            int getX(Icon base, Icon decoration) {
                return base.getIconWidth() - decoration.getIconWidth();
            }

            @Override
            int getY(Icon base, Icon decoration) {
                return base.getIconHeight() - decoration.getIconHeight();
            }
        };


        abstract int getX(Icon var1, Icon var2);

        abstract int getY(Icon var1, Icon var2);
    }
}

