/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import ericsson.ere.defs.RmaDefs;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class ActionBuilder<T extends Builder> {
    public static final String VISIBILITY_CONTROLLER_KEY = "visibility-controller-instance";
    private List<T> myBuilders = new ArrayList<T>();
    private Class<T> myBuilderClass;

    private ActionBuilder(Class<T> builderClass) {
        this.myBuilderClass = builderClass;
    }

    public static ActionBuilder<Builder> newActionBuilder() {
        return new ActionBuilder<Builder>(Builder.class);
    }

    public static <E extends Builder> ActionBuilder<E> newActionBuilder(Class<E> builderClass) {
        return new ActionBuilder<E>(builderClass);
    }

    private T createBuilder(Action a) {
        if (this.myBuilderClass == Builder.class) {
            return (T)new Builder(a);
        }
        try {
            Constructor<T> constr = this.myBuilderClass.getConstructor(Action.class);
            return (T)((Builder)constr.newInstance(a));
        }
        catch (SecurityException ex) {
            throw new AssertionError();
        }
        catch (NoSuchMethodException ex) {
            throw new AssertionError((Object)"Constructor not found though T extends Builder.");
        }
        catch (IllegalArgumentException ex) {
            throw new AssertionError();
        }
        catch (InstantiationException ex) {
            throw new AssertionError((Object)"Could not instantiate. Builder class is abstract?");
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)"Cannot access builder constructor.");
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new AssertionError((Object)ex.getCause());
        }
    }

    public T buildAction(Action a) {
        T b = this.createBuilder(a);
        this.myBuilders.add(b);
        return b;
    }

    public ActionBuilder<T> bindInputForall(ActionMap am, InputMap ... ims) {
        for (Builder b : this.myBuilders) {
            b.bindInput(am, ims);
        }
        this.myBuilders.clear();
        return this;
    }

    public static interface VisibilityController {
        public boolean shouldBeVisible(Action var1, MouseEvent var2);
    }

    public static class Builder {
        protected Action myAction;
        private String myActionKey;

        protected Builder(Action a) {
            this.myAction = a;
            this.myActionKey = UUID.randomUUID().toString();
        }

        public Action get() {
            return this.myAction;
        }

        public Builder withName(String name) {
            this.myAction.putValue("Name", name);
            return this;
        }

        public Builder withDescription(String desc) {
            this.myAction.putValue("ShortDescription", desc);
            return this;
        }

        public Builder withToolTip(String toolTip) {
            this.myAction.putValue("ShortDescription", toolTip);
            return this;
        }

        public Builder withIcon(ImageIcon icon) {
            this.myAction.putValue("SmallIcon", icon);
            return this;
        }

        public Builder withRmaIcon(String icon) {
            return this.withIcon(RmaDefs.getImageIcon(icon));
        }

        public Builder withAccelerator(KeyStroke acc) {
            this.myAction.putValue("AcceleratorKey", acc);
            return this;
        }

        public Builder withAccelerator(String acc) {
            return this.withAccelerator(KeyStroke.getKeyStroke(acc));
        }

        public Builder bindInput(ActionMap am, InputMap ... ims) {
            KeyStroke ks = (KeyStroke)this.myAction.getValue("AcceleratorKey");
            if (ks != null) {
                am.put(this.myActionKey, this.myAction);
                for (InputMap im : ims) {
                    im.put(ks, this.myActionKey);
                }
            }
            return this;
        }

        public Builder visibleBy(VisibilityController vc) {
            this.myAction.putValue(ActionBuilder.VISIBILITY_CONTROLLER_KEY, vc);
            return this;
        }
    }
}

