/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import com.ericsson.ere.swing.ActionBuilder;
import com.ericsson.ere.swing.ConditionallyEnabledAbstractAction;
import com.ericsson.ere.swing.MouseTriggeredPopupMenu;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public abstract class AbstractActionBasedPopupMenu
extends JPopupMenu
implements MouseTriggeredPopupMenu {
    private transient MouseEvent myMouseEvent;

    protected abstract ConditionallyEnabledAbstractAction.ActionContext createActionContext();

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        this.setMenuItemState(this.createActionContext(), this.myMouseEvent, this);
        super.firePopupMenuWillBecomeVisible();
    }

    protected boolean setMenuItemState(ConditionallyEnabledAbstractAction.ActionContext ctx, MouseEvent evt, MenuElement menu) {
        boolean someVisible = false;
        for (MenuElement me : menu.getSubElements()) {
            JMenuItem mi = (JMenuItem)me;
            Action action = mi.getAction();
            ActionBuilder.VisibilityController vc = action != null ? (ActionBuilder.VisibilityController)action.getValue("visibility-controller-instance") : null;
            boolean visible = vc == null || vc.shouldBeVisible(action, evt);
            someVisible |= visible;
            mi.setVisible(visible);
            if (mi instanceof JMenu) {
                if (!visible) continue;
                boolean keepVisible = this.setMenuItemState(ctx, evt, ((JMenu)mi).getPopupMenu());
                mi.setVisible(keepVisible);
                continue;
            }
            if (!visible || !action.isEnabled()) {
                mi.setEnabled(false);
                continue;
            }
            if (!(action instanceof ConditionallyEnabledAbstractAction)) continue;
            ConditionallyEnabledAbstractAction ca = (ConditionallyEnabledAbstractAction)action;
            if (ca.isApplicable(ctx)) {
                mi.setEnabled(ca.shouldBeEnabled(ctx));
                continue;
            }
            mi.setVisible(false);
            mi.setEnabled(false);
        }
        return someVisible;
    }

    @Override
    public void show(MouseEvent e) {
        try {
            this.myMouseEvent = e;
            this.show(e.getComponent(), e.getX(), e.getY());
        }
        finally {
            this.myMouseEvent = null;
        }
    }
}

