/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.interfaces.XMLAppendable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public class ValueFieldCompositeObject
implements XMLAppendable {
    public static final ValueFieldCompositeObject CURRENT_TIME = new ValueFieldCompositeObject(Mode.Value, "CurrentTime()", DataType.TIME, false);
    public static final ValueFieldCompositeObject START_TIME = new ValueFieldCompositeObject(Mode.Value, "StartTime()", DataType.TIME, false);
    private final String myFieldOrValueString;
    private final Mode myMode;
    private final ValueResolver myValueResolver;

    public ValueFieldCompositeObject(Mode mode, String fieldOrValueString) {
        this(mode, fieldOrValueString, null);
    }

    public ValueFieldCompositeObject(Mode mode, String fieldOrValueString, ValueResolver valueResolver) {
        this(mode, fieldOrValueString, valueResolver, true);
    }

    protected ValueFieldCompositeObject(Mode mode, String fieldOrValueString, ValueResolver valueResolver, boolean checkValue) {
        Object o;
        this.checkParameterForNull(fieldOrValueString);
        if (checkValue && mode == Mode.Value && valueResolver != null && (o = valueResolver.parseValueString(fieldOrValueString)) == null) {
            throw new IllegalArgumentException("Cannot parse value by data type: " + fieldOrValueString);
        }
        this.myFieldOrValueString = fieldOrValueString;
        this.myMode = mode;
        this.myValueResolver = valueResolver;
    }

    public ValueFieldCompositeObject(Element element) {
        this.checkParameterForNull(element);
        String fieldAttribute = element.getAttribute("field");
        String dataTypeAttribute = element.getAttribute("datatype");
        if (!"".equals(fieldAttribute) && Boolean.parseBoolean(fieldAttribute)) {
            this.myMode = Mode.Field;
            this.myValueResolver = null;
        } else {
            this.myMode = Mode.Value;
            if (!"".equals(dataTypeAttribute)) {
                DataType dt = DataType.lookup(dataTypeAttribute);
                if (dt == null) {
                    throw new IllegalArgumentException("Unknown data type: " + dataTypeAttribute);
                }
                this.myValueResolver = dt;
            } else {
                this.myValueResolver = null;
            }
        }
        this.myFieldOrValueString = element.getTextContent();
    }

    public static ValueFieldCompositeObject createForField(String field) {
        return new ValueFieldCompositeObject(Mode.Field, field);
    }

    public static ValueFieldCompositeObject createForValue(String value, ValueResolver valueResolver) {
        return new ValueFieldCompositeObject(Mode.Value, value, valueResolver);
    }

    public static ValueFieldCompositeObject createForValueWithoutStringValidation(String valueString, DataType valueDataType) {
        return new ValueFieldCompositeObject(Mode.Value, valueString, valueDataType, false);
    }

    public String getFieldOrValueAsString() {
        return this.myFieldOrValueString;
    }

    public Object getValueAsObject() {
        if (this.myValueResolver == null) {
            return this.myFieldOrValueString;
        }
        return this.myValueResolver.parseValueString(this.myFieldOrValueString);
    }

    public DataType getValueDataType() {
        return this.myValueResolver != null ? this.myValueResolver.getDataType() : null;
    }

    private void checkParameterForNull(Object parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
    }

    public String getXMLRepresentation() {
        Document doc = XMLUtil.createEmptyDocument();
        this.appendXML(doc);
        return DomWriter.nodeToString(doc.getDocumentElement(), false, false);
    }

    @Override
    public void appendXML(Node parent) {
        boolean isField = this.myMode == Mode.Field;
        Document owner = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element valueElement = owner.createElement("Value");
        parent.appendChild(valueElement);
        if (isField) {
            valueElement.setAttribute("field", "true");
        }
        if (this.myValueResolver != null && !isField) {
            DataType dataType = this.myValueResolver.getDataType();
            valueElement.setAttribute("datatype", dataType.getTypeName());
        }
        valueElement.setTextContent(this.myFieldOrValueString);
    }

    public Mode getMode() {
        return this.myMode;
    }

    public String toString() {
        return this.myFieldOrValueString + " (" + (Object)((Object)this.myMode) + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myFieldOrValueString == null ? 0 : this.myFieldOrValueString.hashCode());
        result = 31 * result + (this.myMode == null ? 0 : this.myMode.hashCode());
        result = 31 * result + (this.myValueResolver == null ? 0 : this.myValueResolver.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueFieldCompositeObject other = (ValueFieldCompositeObject)obj;
        if (this.myFieldOrValueString == null ? other.myFieldOrValueString != null : !this.myFieldOrValueString.equals(other.myFieldOrValueString)) {
            return false;
        }
        if (this.myMode == null ? other.myMode != null : !this.myMode.equals((Object)other.myMode)) {
            return false;
        }
        return !(this.myValueResolver == null ? other.myValueResolver != null : !this.myValueResolver.equals(other.myValueResolver));
    }

    public static enum Mode {
        Field,
        Value;

    }
}

