/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.selectiontree.conditions.string.IPVersion;
import com.ericsson.ere.selectiontree.util.SubNet;
import java.math.BigInteger;

@Immutable
public class SubNetIPv6
extends SubNet {
    private SubNetIPv6(BigInteger ipAddress, BigInteger netMask) {
        super(ipAddress, netMask);
    }

    public static SubNetIPv6 parseIPv6SubNetFromString(String subNetString) {
        String[] subNetParts;
        BigInteger netMaskValue = null;
        BigInteger ipValue = null;
        if (subNetString != null && (subNetParts = subNetString.split("/", -1)).length < 3) {
            try {
                netMaskValue = subNetParts.length == 2 ? SubNetIPv6.generateNetMask(Integer.parseInt(subNetParts[1]), IPVersion.IPv6) : SubNetIPv6.generateNetMask(128, IPVersion.IPv6);
                ipValue = SubNetIPv6.parseIPv6FromString(subNetParts[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ipValue != null && netMaskValue != null ? new SubNetIPv6(ipValue, netMaskValue) : null;
    }

    public static boolean isValidIPv6Subnet(String subNetString) {
        return SubNetIPv6.parseIPv6SubNetFromString(subNetString) != null;
    }

    private static BigInteger parseIPv6FromString(String theIPv6Addr) {
        String[] ipAddrParts;
        boolean doubleColonExists;
        int lastIndex;
        int firstIndex;
        boolean isValidIPAddr = false;
        BigInteger ipAddrValue = null;
        if (theIPv6Addr.length() > 1 && SubNetIPv6.isColonValidInIPAddr(theIPv6Addr) && (firstIndex = theIPv6Addr.indexOf("::")) == (lastIndex = theIPv6Addr.lastIndexOf("::")) && SubNetIPv6.isIPAddrPartLengthValid(doubleColonExists = firstIndex >= 0, (ipAddrParts = theIPv6Addr.split(":")).length)) {
            int currentPos = 7;
            int numOfIPAddrParts = ipAddrParts.length;
            ipAddrValue = BigInteger.ZERO;
            isValidIPAddr = true;
            for (int index = 0; index < numOfIPAddrParts; ++index) {
                int ipAddrPartIntValue;
                if (ipAddrParts[index].length() == 0) {
                    currentPos = numOfIPAddrParts - index - 2;
                    continue;
                }
                try {
                    ipAddrPartIntValue = Integer.parseInt(ipAddrParts[index], 16);
                }
                catch (NumberFormatException e) {
                    isValidIPAddr = false;
                    break;
                }
                if (!SubNetIPv6.isIPAddrPartValid(ipAddrPartIntValue) || ipAddrParts[index].length() > 4) {
                    isValidIPAddr = false;
                    break;
                }
                ipAddrValue = ipAddrValue.add(BigInteger.valueOf(ipAddrPartIntValue).shiftLeft(16 * currentPos--));
            }
        }
        return isValidIPAddr ? ipAddrValue : null;
    }

    private static boolean isIPAddrPartValid(int partValue) {
        return partValue >= 0 && partValue <= 65535;
    }

    private static boolean isColonValidInIPAddr(String theIPv6Addr) {
        boolean leadingSemiColonValid = theIPv6Addr.charAt(0) != ':' || theIPv6Addr.charAt(1) == ':';
        int length = theIPv6Addr.length();
        boolean trailingSemiColonValid = theIPv6Addr.charAt(length - 1) != ':' || theIPv6Addr.charAt(length - 2) == ':';
        return leadingSemiColonValid && trailingSemiColonValid;
    }

    private static boolean isIPAddrPartLengthValid(boolean doubleColonExists, int length) {
        return doubleColonExists ? length <= 8 : length == 8;
    }

    @Override
    protected BigInteger parseIPFromString(String theIPv6Addr) {
        return SubNetIPv6.parseIPv6FromString(theIPv6Addr);
    }

    @Override
    protected BigInteger parseIPFromOctetString(String theIPAddr) {
        BigInteger octetIp = null;
        try {
            octetIp = theIPAddr.length() == 32 ? new BigInteger(theIPAddr, 16) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return octetIp;
    }
}

